﻿using System;
using System.Web;
using System.Web.UI.WebControls;
using MSSREnh;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.MSSR;
using AntiXssEnc = Microsoft.Security.Application;

public partial class AddPatient : BasePage
{
    private readonly UserAccountManager _user = (UserAccountManager) HttpContext.Current.User;
    protected MSSRInstrumentsManager MssrInstrumentManager = new MSSRInstrumentsManager();

    protected void Page_Load(object sender, EventArgs e)
    {
        /*** Is User Authorized ***/
        Logging.WriteLogToFile(string.Format("{0} Add New Patient Page Load Start {1}. ", _user.UserName,
            txtAddPatPatientICN.Text));
        if (!IsUserAuthorizedToAddNewPatient())
        {
            Logging.WriteLogToFile(
                String.Format("{0} WARNING - NOT Authorized. Add New Patient Page Load. Error opening add new patient module – Not authorized. Redirecting to error page.", _user.UserName));
            Response.Redirect("ErrorPage.aspx?id=100");
        }

        if (!Page.IsPostBack)
        {
            InitializeFormFields();
        }
    }

    private void InitializeFormFields()
    {
        rblAddPatEthnicity.DataSource = MssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("2", "MSAT");
        rblAddPatEthnicity.DataBind();

        rblAddPatRace.DataSource = MssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("1", "MSAT");
        rblAddPatRace.DataBind();

        rdpDateOfBirth.MaxDate = DateTime.Now.AddDays(-1);
        rdpDateOfDeath.MaxDate = DateTime.Now;
        rblAddPatGender.DataSource = MssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("3", "MSAT");
        rblAddPatGender.DataBind();

        ddlAddPatStdInstitutionId.DataSource = Helpers.GetStations(string.Empty);
        ddlAddPatStdInstitutionId.DataBind();

        ddlAddPatientState.DataSource = Helpers.GetStates();
        ddlAddPatientState.DataBind();

        ddlCauseOfDeathType.DataSource =
            MssrInstrumentManager.GetChoicesByQuestionNumberandSurveyType("COD", "MSAT");
        ddlCauseOfDeathType.DataBind();

        SetBreadCrumb();
    }

    public override string TopMenuName()
    {
        return "Administration";
    }

    public override string MenuItemName()
    {
        return "MSSR ADD NEW PATIENT";
    }

    public override string AppObjectCode()
    {
        return "MSSR ADD NEW PATIENT";
    }

    private void SetBreadCrumb()
    {
        if (Master != null)
        {
            var labelBreadCrumb = (Label) Master.FindControl("LabelBreadCrumb");
            if (labelBreadCrumb != null)
                labelBreadCrumb.Text = " Add New Patient";
        }
    }

    protected void btnAddPatAddPatinet_Click(object sender, EventArgs e)
    {
        Logging.WriteLogToFile(string.Format("{0} Add Patient Start for Patient ICN {1}. ", _user.UserName,
            txtAddPatPatientICN.Text));
        if (Page.IsValid)
        {
            var newPatientToAdd = new AddPatientRequest
            {
                FirstName = txtAddPatPatientFirstName.Text,
                LastName = txtAddPatPatientLastName.Text,
                MiddleName = txtAddPatMiddleName.Text,
                PatientFullName = txtAddPatPatientFullName.Text,
                PatientIcn = txtAddPatPatientICN.Text,
                PatientSid = txtAddPatPatientSID.Text == string.Empty ? null : txtAddPatPatientSID.Text,
                PatientSsn = txtAddPatPatientSoSeN.Text,
                Station = ddlAddPatStdInstitutionId.SelectedValue,
                StationName = ddlAddPatStdInstitutionId.SelectedItem.Text,
                Sta6N = txtAddPatSTA6N.Text,
                Dfn = txtAddPatDFN.Text,
                Age = (int)(rdNumTxtAge.Value ?? 0),
                DateofBirth = rdpDateOfBirth.SelectedDate,
                DateofDeath = rdpDateOfDeath.SelectedDate,
                CauseOfDeath = ddlCauseOfDeathType.SelectedValue == string.Empty ? null : ddlCauseOfDeathType.SelectedValue,
                Race = Helpers.GetRace(rblAddPatRace.SelectedValue),
                Ethnicity = Helpers.GetEthnicity(rblAddPatEthnicity.SelectedValue),
                Gender = Helpers.GetGender(rblAddPatGender.SelectedValue),
                MaritalStatus = ddlAddPatMaritalStatus.SelectedValue == string.Empty ? null : ddlAddPatMaritalStatus.SelectedValue,
                Religion = txtAddPatReligion.Text == string.Empty ? null : txtAddPatReligion.Text,
                City = txtAddPatCity.Text,
                State = ddlAddPatientState.SelectedValue,
                Region = txtAddPatientRegion.Text
            };

            /****   check patinet exist in MSSR db by patient icn/ssn.****/
            var patientManager = new PatientViewManager(CurrentUser);
            if (!patientManager.IsPatientExistInMssr(newPatientToAdd.PatientSsn, newPatientToAdd.PatientIcn))
            {
                if (patientManager.AddPatientToMssr(newPatientToAdd, this._user.UserName).Length == 0)
                {
                    Logging.WriteLogToFile(string.Format("{0} Added Patient ICN {1}. ", _user.UserName,
                        newPatientToAdd.PatientIcn));
                    ResetFormFields();
                    Response.Redirect("NewPatients.aspx");
                }
                else
                {
                    lblStatusMessageAlrt.Text =
                        "Unable to Add this Patient to MSSR Database. Please Contact System Adminstrator.";
                    pnlStatusMessageAlrt.Visible = true;
                }
            }
            else
            {
                lblStatusMessageAlrt.Text = "Patient Already Exist in MSSR Application.";
            }
        }
        else
        {
            pnlValidationError.Visible = true;
            lblValidationErrorMessage.Text = "Please correct the following error and try again.";
            Logging.WriteLogToFile(string.Format("Validation Error Adding Patient ICN {0} - by User {1}. ", txtAddPatPatientICN.Text, _user.UserName));
        }
    }

    protected void rdBtnFindPatient_Click(object sender, EventArgs e)
    {
        Logging.WriteLogToFile(string.Format("{0} Start Search - Load Patient. ", _user.UserName));
        string formattedSosen = rdtxtBoxNewPatSsn.Text.Trim();
        string sosen = formattedSosen.Replace("-", "");
        var patientManager = new PatientViewManager(CurrentUser);
        SearchAndLoadPatientIcnAndDetails_Result newPat =
            patientManager.FindPatientByPatientSsn(sosen);
        if (newPat != null)
        {
            if (patientManager.IsPatientExistInMssr(sosen, string.Empty))
            {
                lblStatusMessagInf.Text = "Patient Already Exist in MSSR Application.";
                pnlLoadMessageInfo.Visible = true;
                Logging.WriteLogToFile(string.Format("{0} Patient Already Exist in MSSR Application. Patient Icn - {1} ",  _user.UserName, newPat.PatientICN));
            }
            else
            { 
                txtAddPatPatientICN.Text = AntiXssEnc.Encoder.HtmlEncode(newPat.PatientICN.ToString());
                txtAddPatPatientSoSeN.Text = AntiXssEnc.Encoder.HtmlEncode(newPat.patientSoSeN);
                txtAddPatPatientSID.Text = AntiXssEnc.Encoder.HtmlEncode(newPat.PatientSID.ToString());
                pnlLoadPanelPatientDetails.Enabled = true;
                lblStatusMessagInf.Text = "Found and Populated Matching Patient.";
                pnlLoadMessageInfo.Visible = true;
                Logging.WriteLogToFile(string.Format("{0} Found and Populated Matching Patient. Patient Icn - {1}", _user.UserName, newPat.PatientICN));
            }
        }
        else
        {
            lblStatusMessageAlrt.Text = "Patient Not Found In CRS. Please Confirm SSN and Try Again.";
            pnlStatusMessageAlrt.Visible = true;
            Logging.WriteLogToFile(string.Format("{0} Patient Not Found In CRS. Please Confirm SSN and Try Again. ", _user.UserName));
        }
        Logging.WriteLogToFile(string.Format("{0} End Search - Load Patient. ", _user.UserName));
    }

    private void ResetFormFields()
    {
        txtAddPatPatientFirstName.Text = string.Empty;
        txtAddPatPatientLastName.Text = string.Empty;
        txtAddPatMiddleName.Text = string.Empty;
        txtAddPatPatientFullName.Text = string.Empty;
        txtAddPatPatientICN.Text = string.Empty;
        txtAddPatPatientSID.Text = string.Empty;
        txtAddPatPatientSoSeN.Text = string.Empty;
        ddlAddPatStdInstitutionId.SelectedIndex = -1;
        txtAddPatSTA6N.Text = string.Empty;
        txtAddPatDFN.Text = string.Empty;
        rdNumTxtAge.Value = null;
        rdpDateOfBirth.SelectedDate = null;
        rdpDateOfDeath.SelectedDate = null;
        rblAddPatRace.SelectedIndex = -1;
        rblAddPatEthnicity.SelectedIndex = -1;
        rblAddPatGender.SelectedIndex = -1;
        ddlAddPatMaritalStatus.SelectedIndex = 0;
        txtAddPatReligion.Text = string.Empty;
        txtAddPatCity.Text = string.Empty;
        ddlAddPatientState.SelectedIndex = 0;
        txtAddPatientRegion.Text = string.Empty;
        rdtxtBoxNewPatSsn.Text = string.Empty;
    }

    private bool IsUserAuthorizedToAddNewPatient()
    {
        Logging.WriteLogToFile(
            string.Format("{0} Add Patient Start for Patient ICN - IsUserAuthorizedToAddNewPatient() {1}. ",
                _user.UserName, txtAddPatPatientICN.Text));
        bool allowedToEdit = false;

        var editMnger = new SurveyEditUserManager();
        allowedToEdit = editMnger.IsUserAuthozizedAddNewPatient(_user);

        return allowedToEdit;
    }

    protected void custValidatorAddNewPatient_ServerValidate(object source, ServerValidateEventArgs args)
    {
        if(string.IsNullOrEmpty(txtAddPatPatientFirstName.Text))
            args.IsValid = rfvTxtAddPatPatientFirstName.IsValid = false;
        if (string.IsNullOrEmpty(txtAddPatPatientLastName.Text))
            args.IsValid = rfvtxtAddPatPatientLastName.IsValid = false;
        if (string.IsNullOrEmpty(txtAddPatPatientFullName.Text))
            args.IsValid = rfvtxtAddPatPatientName.IsValid = false;
        if (string.IsNullOrEmpty(txtAddPatPatientICN.Text))
            args.IsValid = rfvtxtAddPatPatientICN.IsValid = false;
        if (string.IsNullOrEmpty(txtAddPatPatientSoSeN.Text))
            args.IsValid = rfvtxtAddPatPatientSSN.IsValid = false;
        if (string.IsNullOrEmpty(ddlAddPatStdInstitutionId.SelectedValue))
            args.IsValid = rfvddlAddPatStdInstitutionId.IsValid = false;
        if (string.IsNullOrEmpty(txtAddPatSTA6N.Text))
            args.IsValid = rfvtxtAddPatSTA6N.IsValid = false;
        if (rdNumTxtAge.Value == null)
            args.IsValid = rfvtxtAge.IsValid = false;
        if (rdpDateOfBirth.SelectedDate == null)
            args.IsValid = rfvrdpDateOfBirth.IsValid = false;
        if (string.IsNullOrEmpty(rblAddPatRace.SelectedValue))
            args.IsValid = rfvrblAddPatRace.IsValid = false;
        if (string.IsNullOrEmpty(rblAddPatEthnicity.SelectedValue))
            args.IsValid = rfvrblAddPatEthnicity.IsValid = false;
        if (string.IsNullOrEmpty(rblAddPatGender.SelectedValue))
            args.IsValid = rfvrblAddPatGender.IsValid = false;
        if (string.IsNullOrEmpty(txtAddPatCity.Text))
            args.IsValid = rfvtxtAddPatCity.IsValid = false;
        if (string.IsNullOrEmpty(ddlAddPatientState.SelectedValue))
            args.IsValid = rfvddlAddPatientState.IsValid = false;
    }
}