﻿<%@ Page Title="Add New Patient" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="AddPatient.aspx.cs" Inherits="AddPatient" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <telerik:RadScriptManager runat="server" ID="rdScriptManagerAddPatient" />
    <telerik:RadAjaxManager ID="radajaxmanagermsat" runat="server" UpdatePanelsRenderMode="Inline" />
    <telerik:RadSkinManager runat="server" ID="rdSkinptManagerAddPatient" Skin="WebBlue" />
    <telerik:RadAjaxPanel ID="rdajxPanelCreateSurvey" runat="server" LoadingPanelID="radAjxLoadingPanelCreateSurvey">
        <div style="width: 100%">
            <fieldset class="fieldset">
                <legend>| Add New Patient |</legend>
                <asp:CustomValidator ID="custValidatorAddNewPatient" ValidationGroup="AddNewPatient" runat="server" Display="None" OnServerValidate="custValidatorAddNewPatient_ServerValidate"></asp:CustomValidator>
                <div>
                    <asp:Label runat="server" for="rdtxtBoxNewPatSsn">Patient SSN:</asp:Label><span class="requiredField2">*</span>
                    <telerik:RadTextBox runat="server" ID="rdtxtBoxNewPatSsn" ToolTip="Patient SSN" EmptyMessage="###-##-####" MaxLength="11"  />&nbsp;<telerik:RadButton runat="server" ID="rdBtnFindPatient" Text="Load Patient" ValidationGroup="ConfirmPatient" OnClick="rdBtnFindPatient_Click"></telerik:RadButton>
                    <asp:RequiredFieldValidator runat="server" ControlToValidate="rdtxtBoxNewPatSsn" ID="rfvrdtxtBoxNewPatSsn" ValidationGroup="ConfirmPatient"
                        ErrorMessage="* Patient SSN is Required." />
                    <asp:RegularExpressionValidator ID="revrdtxtBoxNewPatSsn" runat="server" ErrorMessage="Invalid SSN" ControlToValidate="rdtxtBoxNewPatSsn" ValidationGroup="ConfirmPatient"
                        ValidationExpression="\d{3}-\d{2}-\d{4}"></asp:RegularExpressionValidator>
                    <asp:Panel runat="server" ID="pnlStatusMessageAlrt" CssClass="pnelerror" Visible="False">
                        <fieldset class="pnleAlert">
                            <div>
                                <img src="images/Warning_yellow_7231_21x20_exp.png" alt="Info" />
                                <asp:Label runat="server" ID="lblStatusMessageAlrt" Text=""></asp:Label>
                            </div>
                        </fieldset>
                    </asp:Panel>
                    <asp:Panel runat="server" ID="pnlLoadMessageInfo" CssClass="pnleInfor" Visible="False">
                        <fieldset class="pnlStatusMessag">
                            <div>
                                <img src="images/Information_blue_6227_21x20_exp.png" alt="Info" />
                                <asp:Label runat="server" ID="lblStatusMessagInf" Text=""></asp:Label>
                            </div>
                        </fieldset>
                    </asp:Panel>
                    <div>
                        <asp:Panel runat="server" ID="pnlValidationError" CssClass="pnelerror" Visible="False">
                            <fieldset class="pnleAlert">
                                <div>
                                    <img src="images/Warning_yellow_7231_21x20_exp.png" alt="Info" />
                                    <asp:Label runat="server" ID="lblValidationErrorMessage" Text=""></asp:Label>
                                </div>
                            </fieldset>
                        </asp:Panel>
                    </div>
                </div>
                <div id="divAddPat">
                    <fieldset>
                        <legend>Patient Details  </legend>
                        <div class="divTopPanel">
                        </div>
                        <asp:Panel runat="server" ID="pnlLoadPanelPatientDetails" Enabled="False" CssClass="mainpPnl" LoadingPanelID="radAjaxLoadPanel">
                            <div style="padding-left: 35px;">
                                <div class="divAddPat2">
                                    <div class="div_row">
                                        <div class="leftColumn">
                                            <asp:Label runat="server" for="txtAddPatPatientSSN">Patient SSN</asp:Label><span class="requiredField2">*</span>
                                        </div>
                                        <div class="rightColumn">
                                            <telerik:RadTextBox runat="server" ID="txtAddPatPatientSoSeN" ReadOnly="True" BackColor="#FFFFCC" EmptyMessage="###-##-####"  ToolTip="Patient SSN" />
                                            <asp:RequiredFieldValidator runat="server" ControlToValidate="txtAddPatPatientSoSeN" ID="rfvtxtAddPatPatientSSN" ValidationGroup="AddNewPatient"
                                                ErrorMessage="* Patient SSN is Required." />
                                        </div>
                                    </div>
                                    <div class="div_row">
                                        <div class="leftColumn">
                                            <asp:Label runat="server" for="txtAddPatPatientICN">Patient ICN</asp:Label><span class="requiredField2">*</span>
                                        </div>
                                        <div class="rightColumn">
                                            <telerik:RadTextBox runat="server" ID="txtAddPatPatientICN" ReadOnly="True" ValidationGroup="AddNewPatient" BackColor="#FFFFCC" ToolTip="Patient ICN" />
                                            <asp:RequiredFieldValidator runat="server" ControlToValidate="txtAddPatPatientICN" ID="rfvtxtAddPatPatientICN" ValidationGroup="AddNewPatient"
                                                ErrorMessage="* Patient ICN is Required." />
                                        </div>
                                    </div>
                                    <div class="div_row">
                                        <div class="leftColumn">
                                            <asp:Label runat="server" for="txtAddPatPatientSID">Patient SID</asp:Label>
                                        </div>
                                        <div class="rightColumn">
                                            <telerik:RadTextBox ID="txtAddPatPatientSID" runat="server" ReadOnly="True" BackColor="#FFFFCC" ToolTip="Patient SID"></telerik:RadTextBox>
                                        </div>
                                    </div>
                                    <div class="div_row">
                                        <div class="leftColumn">
                                            <asp:Label runat="server" for="txtAddPatPatientFirstName">First Name</asp:Label><span class="requiredField2">*</span>
                                        </div>
                                        <div class="rightColumn">
                                            <telerik:RadTextBox runat="server" ID="txtAddPatPatientFirstName" ToolTip="First Name" ValidationGroup="AddNewPatient" />
                                            <asp:RequiredFieldValidator runat="server" ControlToValidate="txtAddPatPatientFirstName" ID="rfvTxtAddPatPatientFirstName" ValidationGroup="AddNewPatient"
                                                ErrorMessage="* Patient First Name is Required." />
                                        </div>
                                    </div>
                                    <div class="div_row">
                                        <div class="leftColumn">
                                            <asp:Label runat="server" for="txtAddPatPatientLastName">Last Name</asp:Label><span class="requiredField2">*</span>
                                        </div>
                                        <div class="rightColumn">
                                            <telerik:RadTextBox runat="server" ID="txtAddPatPatientLastName" ValidationGroup="AddNewPatient" ToolTip="Last Name" />
                                            <asp:RequiredFieldValidator runat="server" ControlToValidate="txtAddPatPatientLastName" ID="rfvtxtAddPatPatientLastName" ValidationGroup="AddNewPatient"
                                                ErrorMessage="* Patient Last Name is Required." />
                                        </div>
                                    </div>
                                    <div class="div_row">
                                        <div class="leftColumn">
                                            <asp:Label runat="server" for="txtAddPatMiddleName">Middle Name</asp:Label>
                                        </div>
                                        <div class="rightColumn">
                                            <telerik:RadTextBox runat="server" ID="txtAddPatMiddleName" ValidationGroup="AddNewPatient" ToolTip="Middle Name" />
                                        </div>
                                    </div>
                                    <div class="div_row">
                                        <div class="leftColumn">
                                            <asp:Label runat="server" for="txtAddPatPatientName">Full Name</asp:Label><span class="requiredField2">*</span>
                                        </div>
                                        <div class="rightColumn">
                                            <telerik:RadTextBox runat="server" ID="txtAddPatPatientFullName" ValidationGroup="AddNewPatient" ToolTip="Patient Full Name" />
                                            <asp:RequiredFieldValidator runat="server" ControlToValidate="txtAddPatPatientFullName" ID="rfvtxtAddPatPatientName" ValidationGroup="AddNewPatient"
                                                ErrorMessage="* Patient Full Name is Required." />
                                        </div>
                                    </div>
                                    <div class="div_row">
                                        <div class="leftColumn">
                                            <span>DFN</span>
                                        </div>
                                        <div class="rightColumn">
                                            <telerik:RadTextBox runat="server" ID="txtAddPatDFN" ToolTip="DFN" />
                                        </div>
                                    </div>
                                </div>
                                <div class="div_row">
                                    <div class="leftColumn"><span>Age</span><span class="requiredField2">*</span></div>
                                    <div class="rightColumn">
                                        <telerik:RadNumericTextBox runat="server" ToolTip="Age" CssClass="telage" Width="40px" ID="rdNumTxtAge" NumberFormat-DecimalDigits="0" MinValue="1" MaxValue="120" ShowSpinButtons="True" ValidationGroup="AddNewPatient"></telerik:RadNumericTextBox>
                                        <asp:RequiredFieldValidator runat="server" ControlToValidate="rdNumTxtAge" ID="rfvtxtAge" ValidationGroup="AddNewPatient"
                                            ErrorMessage="* Age is Required." />
                                    </div>
                                </div>
                                <div class="divAddPat2">
                                    <div class="div_row">
                                        <div class="leftColumn"><span>Date Of Birth</span><span class="requiredField2">*</span></div>
                                        <div class="rightColumn">
                                            <telerik:RadDatePicker ID="rdpDateOfBirth" ToolTip="Date Of Birth" CssClass="telCalendar" MinDate="1/1/1900" runat="server" />
                                            <asp:RequiredFieldValidator runat="server" ControlToValidate="rdpDateOfBirth" ID="rfvrdpDateOfBirth" ValidationGroup="AddNewPatient"
                                                ErrorMessage="* Date of birth is Required." />
                                        </div>
                                    </div>
                                    <div class="div_row">
                                        <div class="leftColumn"><span>Race</span><span class="requiredField2">*</span></div>
                                        <div class="rightColumn">
                                            <asp:RadioButtonList ID="rblAddPatRace" ToolTip="Race" runat="server" RepeatDirection="Vertical" AutoPostBack="False"
                                                 DataTextField="CHOICE_TEXT" DataValueField="CHOICE_TEXT"
                                                CssClass="" ValidationGroup="OnSave">
                                            </asp:RadioButtonList>
                                            <asp:RequiredFieldValidator runat="server" ControlToValidate="rblAddPatRace" ID="rfvrblAddPatRace" ValidationGroup="AddNewPatient"
                                                ErrorMessage="* Race is Required." />
                                        </div>
                                    </div>
                                    <div class="div_row" style="clear: both">
                                        <div class="leftColumn"><span>Ethnicity</span><span class="requiredField2">*</span></div>
                                        <div class="rightColumn">
                                            <asp:RadioButtonList ID="rblAddPatEthnicity" ToolTip="Ethnicity" runat="server" RepeatDirection="Vertical" 
                                                DataTextField="CHOICE_TEXT" DataValueField="CHOICE_TEXT" CssClass=""
                                                ValidationGroup="OnSave">
                                            </asp:RadioButtonList>
                                            <asp:RequiredFieldValidator runat="server" ControlToValidate="rblAddPatEthnicity" ID="rfvrblAddPatEthnicity" ValidationGroup="AddNewPatient"
                                                ErrorMessage="* Ethnicity is Required." />
                                        </div>
                                    </div>
                                    <div class="div_row" style="clear: both">
                                        <div class="leftColumn"><span>Gender</span><span class="requiredField2">*</span></div>
                                        <div class="rightColumn">
                                            <asp:RadioButtonList ID="rblAddPatGender" ToolTip="Gender" runat="server" RepeatDirection="Vertical"
                                                DataTextField="CHOICE_TEXT" DataValueField="CHOICE_TEXT">
                                            </asp:RadioButtonList>
                                            <asp:RequiredFieldValidator runat="server" ControlToValidate="rblAddPatGender" ID="rfvrblAddPatGender" ValidationGroup="AddNewPatient"
                                                ErrorMessage="* Gender is Required." />
                                        </div>
                                    </div>
                                </div>
                                <div class="div_row" style="clear: both">
                                    <div class="leftColumn"><span>Marital Status</span></div>
                                    <div class="rightColumn">
                                        <telerik:RadComboBox runat="server" ToolTip="Marital Status" CssClass="telselect" ID="ddlAddPatMaritalStatus" EmptyMessage="-- Select Station --">
                                            <Items>
                                                <telerik:RadComboBoxItem runat="server" Value="Single" Text="Single" />
                                                <telerik:RadComboBoxItem runat="server" Value="Divorced" Text="Divorced" />
                                                <telerik:RadComboBoxItem runat="server" Value="Married" Text="Married" />
                                                <telerik:RadComboBoxItem runat="server" Value="Never married" Text="Never married" />
                                                <telerik:RadComboBoxItem runat="server" Value="Separated" Text="Separated" />
                                                <telerik:RadComboBoxItem runat="server" Value="Unknown" Text="Unknown" />
                                                <telerik:RadComboBoxItem runat="server" Value="Widowed" Text="Widowed" />
                                            </Items>
                                        </telerik:RadComboBox>
                                    </div>
                                </div>
                                <div class="div_row divAddPat2">
                                    <div class="leftColumn"><span>Religion</span></div>
                                    <div class="rightColumn">
                                        <telerik:RadTextBox runat="server" ToolTip="Religion" ID="txtAddPatReligion" />
                                    </div>
                                </div>
                                <div class="div_row divAddPat2">
                                    <div class="leftColumn"><span>Date Of Death</span></div>
                                    <div class="rightColumn">
                                        <telerik:RadDatePicker ID="rdpDateOfDeath" ToolTip="Date Of Death" CssClass="telCalendar" MinDate="1/1/1900" runat="server" />
                                    </div>
                                </div>
                                <div class="div_row">
                                    <div class="leftColumn"><span>Cause Of Death</span></div>
                                    <div class="rightColumn">
                                        <telerik:RadComboBox runat="server" ID="ddlCauseOfDeathType" ToolTip="Cause Of Death" AppendDataBoundItems="True" EmptyMessage="-- Select Cause of Death --" CssClass="telselect" DataTextField="CHOICE_TEXT" DataValueField="CHOICE_TEXT">
                                        </telerik:RadComboBox>
                                    </div>
                                </div>
                                <div class="div_row">
                                    <div class="leftColumn">
                                        <asp:Label runat="server" for="ddlAddPatStdInstitutionId">Patient Parent Station</asp:Label><span class="requiredField2">*</span>
                                    </div>
                                    <div class="rightColumn">
                                        <telerik:RadComboBox DataTextField="Description" EmptyMessage="--Select Patient Parent Station--" ToolTip="Station" DataValueField="Code" CssClass="telselect" ID="ddlAddPatStdInstitutionId" runat="server" ValidationGroup="AddNewPatient">
                                        </telerik:RadComboBox>
                                        <asp:RequiredFieldValidator runat="server" ControlToValidate="ddlAddPatStdInstitutionId" ID="rfvddlAddPatStdInstitutionId" ValidationGroup="AddNewPatient"
                                            ErrorMessage="* Station is Required." />
                                    </div>
                                </div>
                                <div class="div_row divAddPat2">
                                    <div class="leftColumn">
                                        <asp:Label runat="server" for="txtAddPatSTA6N">STA6N</asp:Label><span class="requiredField2">*</span>
                                    </div>
                                    <div class="rightColumn">
                                        <telerik:RadTextBox runat="server" ID="txtAddPatSTA6N" ValidationGroup="AddNewPatient" ToolTip="STA6N" />
                                        <asp:RequiredFieldValidator runat="server" ControlToValidate="txtAddPatSTA6N" ID="rfvtxtAddPatSTA6N" ValidationGroup="AddNewPatient"
                                            ErrorMessage="* STA6N is Required." />
                                    </div>
                                </div>
                                <div class="div_row divAddPat2">
                                    <div class="leftColumn"><span>City</span><span class="requiredField2">*</span></div>
                                    <div class="rightColumn">
                                        <telerik:RadTextBox runat="server" ToolTip="City" ID="txtAddPatCity" />
                                        <asp:RequiredFieldValidator runat="server" ControlToValidate="txtAddPatCity" ID="rfvtxtAddPatCity" ValidationGroup="AddNewPatient"
                                            ErrorMessage="* City is Required." />
                                    </div>
                                </div>
                                <div class="div_row">
                                    <div class="leftColumn"><span>State</span><span class="requiredField2">*</span></div>
                                    <div class="rightColumn">
                                        <telerik:RadComboBox runat="server" ID="ddlAddPatientState" DataTextField="Name" EmptyMessage="-- Select State --" AppendDataBoundItems="True" ToolTip="State" CssClass="telselect" DataValueField="Name">
                                        </telerik:RadComboBox>
                                        <asp:RequiredFieldValidator runat="server" ControlToValidate="ddlAddPatientState" ID="rfvddlAddPatientState" ValidationGroup="AddNewPatient"
                                            ErrorMessage="* State is Required." />
                                    </div>
                                </div>
                                <div class="div_row divAddPat2">
                                    <div class="leftColumn"><span>Region</span></div>
                                    <div class="rightColumn">
                                        <telerik:RadTextBox runat="server" ID="txtAddPatientRegion" ToolTip="Region" />
                                        <asp:RegularExpressionValidator ID="rxftxtAddPatientRegion" runat="server" ControlToValidate="txtAddPatientRegion" ValidationExpression="^[0-9]+$" ErrorMessage="* Region Should be Number"></asp:RegularExpressionValidator>
                                    </div>
                                </div>
                                <div class="div_row" style="padding-top: 60px; padding-bottom: 15px">
                                    <div class="leftColumn"></div>
                                    <div class="rightColumn">
                                        <telerik:RadButton ID="btnAddPatAddPatinet" runat="server" CausesValidation="True" ToolTip="Add Patient" Text="Add Patient" OnClick="btnAddPatAddPatinet_Click" ValidationGroup="AddNewPatient" />
                                    </div>
                                </div>
                            </div>
                        </asp:Panel>
                        <div class="divTopBtm">
                        </div>
                    </fieldset>
                </div>
            </fieldset>
        </div>
        <telerik:RadAjaxLoadingPanel ID="radAjxLoadingPanelCreateSurvey" runat="server"></telerik:RadAjaxLoadingPanel>
    </telerik:RadAjaxPanel>
</asp:Content>













