﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using System.Configuration;
using System.Threading;
using System.Net;
using System.Data;
using DataAccess;


namespace RevampResmedService
{
    class CServiceTimer
    {
        private bool Processing { get; set; }

        public CServiceTimer()
        {
            Processing = false;
        }

        /// <summary>
        /// timer fired
        /// </summary>
        /// <param name="stateInfo"></param>
        public void OnTimer(Object stateInfo)
        {
            //don't run if already running
            if (Processing)
            {
                return;
            }
            Processing = true;
            
            CLogEvent evt = new CLogEvent();
            evt.LogEvent(CLogEvent.EventMessage.nTIMER_START, EventLogEntryType.Information);
            
            //thread off importing data
            CResmedXfer xfer = new CResmedXfer();
            xfer.ImportData();
                        
            //done
            Processing = false;
            evt.LogEvent(CLogEvent.EventMessage.nTIMER_DONE, EventLogEntryType.Information);

        }
    }
}
