﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ResmedAVXHelper
{
    /// <summary>
    /// Settings. Note: Setting only included if applicable to the mode.
    /// </summary>
    public class CSettings
    {
        /// <summary>
        /// The set pressure in cmH2O
        /// </summary>
        public string press { set; get; }

        /// <summary>
        /// The maximum allowable pressure in cmH2O
        /// </summary>
        public string maxPress { set; get; }

        /// <summary>
        /// The minimum allowable pressure in cmH2O
        /// </summary>
        public string minPress { set; get; }

        /// <summary>
        /// Expiratory Pressure Relief type
        /// </summary>
        public string EPRType { set; get; }

        /// <summary>
        /// Expiratory Pressure Relief level (relevant if EPRType not OFF)
        /// </summary>
        public string EPRLevel { set; get; }

        /// <summary>
        /// Desaturation Rule Threshold setting
        /// </summary>
        public string ODIThreshold { set; get; }

        /// <summary>
        /// Intelligent Backup Rate Enable setting
        /// </summary>
        public string iBREnable { set; get; }

        /// <summary>
        /// Auto EPAP Enable setting
        /// </summary>
        public string EPAPAutoEnable { set; get; }

        /// <summary>
        /// Inspiratory Positive Airway Pressure setting
        /// </summary>
        public string IPAP { set; get; }


        /// <summary>
        /// Expiratory Positive Airway Pressure setting
        /// </summary>
        public string EPAP { set; get; }

        /// <summary>
        /// AutoSet Response Setting On (Soft) / Off (Standard)
        /// </summary>
        public string autosetResponse { set; get; }

        /// <summary>
        /// Minimum EPAP setting
        /// </summary>
        public string minEPAP { set; get; }

        /// <summary>
        /// Maximum EPAP setting
        /// </summary>
        public string maxEPAP { set; get; }

        /// <summary>
        /// Minimum Pressure Support setting
        /// </summary>
        public string minPS { set; get; }

        /// <summary>
        /// Maximum Pressure Support setting
        /// </summary>
        public string maxPS { set; get; }

    }
}
