﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ResmedAVXHelper
{
    /// <summary>
    /// SessionData structure
    /// </summary>
    public class CSessionData
    {
        /// <summary>
        /// System time of data receipt to AirView
        /// </summary>
        public string receiptTime { set; get; }

        /// <summary>
        /// Session date
        /// </summary>
        public string sessionDate { set; get; }

        /// <summary>
        /// Device ID
        /// </summary>
        public CDeviceID deviceID { set; get; }

        /// <summary>
        /// Usage data (Mask On/Off)
        /// </summary>
        public CUsage usage { set; get; }

        /// <summary>
        /// Settings. Note: Setting only included if applicable to the mode.
        /// </summary>
        public CSettings set { set; get; }

        /// <summary>
        /// Clinical Metrics
        /// </summary>
        public CClinicalMetrics clinicalMetrics { set; get; }

        /// <summary>
        /// Respiratory event indices recorded over the session
        /// Event data (AHI, HI, AI, ...)
        /// </summary>
        public CEvent respEvents { set; get; }

        /// <summary>
        /// Climate control items for the session.
        ///Note: Only returned for Air Solutions devices.
        /// </summary>
        public CPatientInterface patientInterface { set; get; }
    }
}
