﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ResmedAVXHelper
{
    /// <summary>
    /// Climate control items for the session. 
    /// Note: Only returned for Air Solutions devices.
    /// </summary>
    public class CPatientInterface
    {
        /// <summary>
        /// Type of humidifier used on this day – Endcap, internal, or external
        /// </summary>
        public string humidifier { set; get; }

        /// <summary>
        /// Type of heated tube used on this day – None, 15mm
        /// (ClimateLine) or 19mm (ClimateLine Max)
        /// </summary>
        public string heatedTube { set; get; }

        /// <summary>
        /// Absolute ambient humidity for the session in milligrams of 
        /// water per liter.
        /// Note: Only returned if humidification was used for the session.
        /// </summary>
        public string ambHumidity { set; get; }
    }
}
