﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ResmedAVXHelper
{
    /// <summary>
    /// Respiratory event indices recorded over the session
    /// Event structure (AHI, HI, AI, ...)
    /// </summary>
    public class CEvent
    {
        /// <summary>
        /// Apnea–hypopnea index in events per hour
        /// </summary>
        public string AHI { set; get; }

        /// <summary>
        /// Hypopnea index in events per hour
        /// </summary>
        public string HI { set; get; }

        /// <summary>
        /// Apnea index in events per hour
        /// </summary>
        public string AI { set; get; }

        /// <summary>
        /// Obstructive apnea index in events per hour
        /// </summary>
        public string OAI { set; get; }

        /// <summary>
        /// Central apnea index in events per hour
        /// </summary>
        public string CAI { set; get; }

        /// <summary>
        /// Unknown apnea index in events per hour
        /// </summary>
        public string UAI { set; get; }

        /// <summary>
        /// Oxygen Desaturation Index
        /// </summary>
        public string ODI { set; get; }

        /// <summary>
        /// Cheyne Stokes Respiration in minutes
        /// </summary>
        public string CSR { set; get; }

        /// <summary>
        /// Respiratory Effort Related Arousal in events per hour
        /// </summary>
        public string RERA { set; get; }

    }
}
