﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ResmedAVXHelper
{
    /// <summary>
    /// Device ID
    /// </summary>
    public class CDeviceID
    {
        /// <summary>
        /// Therapy mode that device was in on this day
        /// </summary>
        public string mode { set; get; }

        /// <summary>
        /// Device ID information
        /// </summary>
        public CDevice device { set; get; }
    }

    /// <summary>
    /// Device ID information
    /// </summary>
    public class CDevice
    {
        /// <summary>
        /// Serial number of the device used by the patient on this day
        /// </summary>
        public string serialNo { set; get; }

        /// <summary>
        /// Type of device used by the patient on this day
        /// </summary>
        public string deviceType { set; get; }

        /// <summary>
        /// Description of type of device used by patient on this day
        /// 026001 = S9 AutoSet
        /// 026002 = S9 Elite 
        /// 026003 = S9 Escape 
        /// 026004 = S9 Escape Auto 
        /// 026009 = S9 VPAP Auto 
        /// 026011 = VPAP S (S9) 
        /// 026012 = VPAP ST (S9) 
        /// 026013 = VPAP Adapt (S9) 
        /// 026016 = VPAP Adapt (S9 w/ ASVAuto) 
        /// 026018 = VPAP ST-A 
        /// 026023 = VPAP COPD 
        /// </summary>
        public string deviceTypeDesc { set; get; }

    }
}
