﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Newtonsoft;
using Newtonsoft.Json;

namespace ResmedAVXHelper
{
    /// <summary>
    /// Clinical Metrics
    /// </summary>
    public class CClinicalMetrics
    {
        /// <summary>
        /// tgtIPAP metrics (Target inhalation positive airway pressure).
        /// </summary>
        public CTgtIPAP tgtIPAP { set; get; }

        /// <summary>
        /// tgtEPAP metrics (Target exhalation positive airway pressure)
        /// </summary>
        public CTgtEPAP tgtEPAP { set; get; }
        
        /// <summary>
        /// Leak Metric
        /// </summary>
        public CLeak leak { set; get; }

        /// <summary>
        /// Respiratory rate metrics
        /// </summary>
        public CRespRate respRate { set; get; }

        /// <summary>
        /// ieRatio metrics (inhalation:exhalation ratio)
        /// </summary>
        public CIERatio ieRatio { set; get; }

        /// <summary>
        /// Minute ventilation metrics
        /// </summary>
        public CMinuteVent minuteVent { set; get; }

        /// <summary>
        /// Tidal volume metrics
        /// </summary>
        public CTidalVol tidalVol { set; get; }

        /// <summary>
        /// SpO2 metrics
        /// </summary>
        public CSPO2 SPO2 { set; get; }

        /// <summary>
        /// Alveolar ventilation metrics
        /// </summary>
        public CAlveolarVentilation alveolarVentilation { set; get; }

        /// <summary>
        /// Percentage of spontaneous triggered breaths
        /// </summary>
        public string spontTriggBreaths { set; get; }

        /// <summary>
        /// Percentage of spontaneous cycled breaths
        /// </summary>
        public string spontCycledBreaths { set; get; }
    }

    /// <summary>
    /// tgtIPAP metrics (Target inhalation positive airway pressure).
    /// </summary>
    public class CTgtIPAP
    {
        /// <summary>
        /// 95% of target IPAP in cmH2O
        /// </summary>
        [JsonProperty("95")]
        public string ninetyfive { set; get; }

        /// <summary>
        /// Median target IPAP in cmH2O
        /// </summary>
        [JsonProperty("50")]
        public string median { set; get; }

        /// <summary>
        /// Maximum target IPAP in cmH2O
        /// </summary>
        public string max { set; get; }
    }

    /// <summary>
    /// tgtEPAP metrics (Target exhalation positive airway pressure)
    /// </summary>
    public class CTgtEPAP
    {
        /// <summary>
        /// 95% of target EPAP in cmH2O
        /// </summary>
        [JsonProperty("95")]
        public string ninetyfive { set; get; }

        /// <summary>
        /// Median target EPAP in cmH2O
        /// </summary>
        [JsonProperty("50")]
        public string median { set; get; }

        /// <summary>
        /// Maximum target EPAP in cmH2O
        /// </summary>
        public string max { set; get; }
    }

    /// <summary>
    /// Leak metrics
    /// </summary>
    public class CLeak
    {
        /// <summary>
        /// 95% of leak in liters per second
        /// </summary>
        [JsonProperty("95")]
        public string ninetyfive { set; get; }

        /// <summary>
        /// Median leak in liters per second
        /// </summary>
        [JsonProperty("50")]
        public string median { set; get; }

        /// <summary>
        /// Maximum leak in liters per second
        /// </summary>
        public string max { set; get; }
    }

    /// <summary>
    /// Respiratory rate metrics
    /// </summary>
    public class CRespRate
    {
        /// <summary>
        /// 95% respiratory rate in breaths per minute
        /// </summary>
        [JsonProperty("95")]
        public string ninetyfive { set; get; }

        /// <summary>
        /// Median respiratory rate in breaths per minute
        /// </summary>
        [JsonProperty("50")]
        public string median { set; get; }

        /// <summary>
        /// Maximum respiratory rate in breaths per minute
        /// </summary>
        public string max { set; get; }
    }

    /// <summary>
    /// ieRatio metrics (inhalation:exhalation ratio)
    /// </summary>
    public class CIERatio
    {
        /// <summary>
        /// 95% of I:E ratio
        /// </summary>
        [JsonProperty("95")]
        public string ninetyfive { set; get; }

        /// <summary>
        /// Median I:E ratio
        /// </summary>
        [JsonProperty("50")]
        public string median { set; get; }

        /// <summary>
        /// Maximum I:E ratio
        /// </summary>
        public string max { set; get; }
    }

    /// <summary>
    /// Minute ventilation metrics
    /// </summary>
    public class CMinuteVent
    {
        /// <summary>
        /// 95% of minute ventilation in liters per minute
        /// </summary>
        [JsonProperty("95")]
        public string ninetyfive { set; get; }

        /// <summary>
        /// Median minute ventilation in liters per minute
        /// </summary>
        [JsonProperty("50")]
        public string median { set; get; }

        /// <summary>
        /// Maximum minute ventilation in liters per minute
        /// </summary>
        public string max { set; get; }
    }

    /// <summary>
    /// Tidal volume metrics
    /// </summary>
    public class CTidalVol
    {
        /// <summary>
        /// 95% of tidal volume in liters
        /// </summary>
        [JsonProperty("95")]
        public string ninetyfive { set; get; }

        /// <summary>
        /// Median tidal volume in liters
        /// </summary>
        [JsonProperty("50")]
        public string median { set; get; }

        /// <summary>
        /// Maximum tidal volume in liters
        /// </summary>
        public string max { set; get; }
    }

    /// <summary>
    /// SpO2 metrics
    /// </summary>
    public class CSPO2
    {
        /// <summary>
        /// minimum
        /// </summary>
        public string min { set; get; }

        /// <summary>
        /// 95%
        /// </summary>
        [JsonProperty("95")]
        public string ninetyfive { set; get; }

        /// <summary>
        /// 50% Median
        /// </summary>
        [JsonProperty("50")]
        public string median { set; get; }

        /// <summary>
        /// SpO2 minutes under the 88% threshold
        /// </summary>
        public string minutesBelow88percent { set; get; }

        /// <summary>
        /// SpO2 seconds under dynamic threshold
        /// </summary>
        public string secondsBelowDynamicThreshold { set; get; }

    }

    /// <summary>
    /// Alveolar ventilation metrics
    /// </summary>
    public class CAlveolarVentilation
    {
        /// <summary>
        /// 95% of alveolar ventilation in liters per minute
        /// </summary>
        [JsonProperty("95")]
        public string ninetyfive { set; get; }

        /// <summary>
        /// Median alveolar ventilation in liters per minute
        /// </summary>
        [JsonProperty("50")]
        public string median { set; get; }

        /// <summary>
        /// Maximum alveolar ventilation in liters per minute
        /// </summary>
        public string max { set; get; }
    }

}
