﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using System.Configuration;
using System.Threading;
using System.Net;
using System.Data;
using DataAccess;

using WinSCP;


namespace RevampPhilipsService
{
    class CServiceTimer
    {
        private bool Processing { get; set; }

        public CServiceTimer()
        {
            Processing = false;
        }

        /// <summary>
        /// timer fired
        /// </summary>
        /// <param name="stateInfo"></param>
        public void OnTimer(Object stateInfo)
        {
            bool bNewFiles = false; //do we have new files or not
            int nNewFiles = 0; //count of new files

            //don't run if already running
            if (Processing)
            {
                return;
            }
            Processing = true;
            
            CLogEvent evt = new CLogEvent();
            evt.LogEvent(CLogEvent.EventMessage.nTIMER_START, EventLogEntryType.Information);
            
            //get new files from SFTP
            CSFTP sftp = new CSFTP();
            bNewFiles = sftp.GetFiles(ref evt, ref nNewFiles);

            if (bNewFiles)
            {
                if (nNewFiles == 0)
                {
                    evt.LogEvent(CLogEvent.EventMessage.nNO_AVAILABLE_FILES, EventLogEntryType.Information);
                }
                else
                {
                    evt.EventMessages[(int)CLogEvent.EventMessage.nDETAIL_MESSAGE] = String.Format("Found {0} file(s) to process.", nNewFiles);
                    evt.LogEvent(CLogEvent.EventMessage.nDETAIL_MESSAGE, EventLogEntryType.Information);
                    //thread off importing phillips data
                    CPhilipsXfer xfer = new CPhilipsXfer();
                    xfer.ImportPhilipsData();
                }
            }
            else
            {
                evt.LogEvent(CLogEvent.EventMessage.nNO_AVAILABLE_FILES, EventLogEntryType.Information);
            }
                        
            //done
            Processing = false;
            evt.LogEvent(CLogEvent.EventMessage.nTIMER_DONE, EventLogEntryType.Information);

        }
    }
}
