﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.Data;
using System.Threading.Tasks;
using System.Threading;
using System.Diagnostics;

using System.Configuration;

using DataAccess;

namespace RevampPhilipsService
{
    public class CPhilipsXferList : ArrayList
    {
        /// <summary>
        /// US:5341 constructor
        /// </summary>
        public CPhilipsXferList()
        {
            //set the lists initial capacity
            this.Capacity = 500;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="handle"></param>
        public void QueueTransfer(ManualResetEvent handle)
        {
            ThreadPool.QueueUserWorkItem(new WaitCallback(this.DoWork), handle);
        }

        /// <summary>
        /// do the actual work of assigning the checklist
        /// </summary>
        /// <param name="state"></param>
        public void DoWork(Object state)
        {
            ManualResetEvent waitHandle = (ManualResetEvent)state;

            CLogEvent evt = new CLogEvent();
            string strMsg = String.Empty;

            CDataConnection conn = null;
            string strConnectionString = String.Empty;
            bool bAudit = true;
            
            ////status info
            //long lStatusCode = 0;
            //string strStatusComment = String.Empty;

            //connection settings
            try
            {
                string strUseCnnConfig = "DBConnString_" + ConfigurationManager.AppSettings["APP_TARGET_ENV"];
                strConnectionString = ConfigurationManager.ConnectionStrings[strUseCnnConfig].ConnectionString;
                bAudit = (ConfigurationManager.AppSettings["AUDIT"] == "1") ? true : false;
            }
            catch (ConfigurationErrorsException e)
            {
                if (e != null)
                {
                    evt.LogEvent(CLogEvent.EventMessage.nERROR_THREAD_CONFIG_FILE, EventLogEntryType.Error);
                    //lets inform the main thread that this method has finished the execution.
                    waitHandle.Set();
                    return;
                }
            }

            //connect to data source
            conn = new CDataConnection();
            if (!conn.Connect(strConnectionString, (int)DataConnectionType.Oracle, false))
            {
                evt.LogEvent(CLogEvent.EventMessage.nERROR_CONNECTING_DB, EventLogEntryType.Error);
                //lets inform the main thread that this method has finished the execution.
                waitHandle.Set();
                return;
            }
            else
            {
                for (int i = 0; i < this.Count; i++)
                {
                    CPhilipsXferItem xfer = (CPhilipsXferItem)this[i];
                    if (xfer != null)
                    {
                        xfer.Save(ref conn);
                    }

                }

                //close connection
                conn.Close();
            }

            //lets inform the main thread that this method has finished the execution.
            waitHandle.Set();

        }
    }
}