﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;

namespace RevampPhilipsService
{
    public class CLogEvent
    {
        public enum EventMessage
        {
            nDETAIL_MESSAGE,
            nSERVICE_STARTING,
            nSUCCESS_CONN_DB,
            nSWITCH_TO_CONFIG,
            nSWITCH_TO_DEFAULT_INTERVALS,
            nTIMER_START,
            nTIMER_DONE,
            //nRESMED_AVX_UNAVAILABLE,
            nSEARCHING_AVAILABLE_FILES,
            nNO_AVAILABLE_FILES,
            //nINVALID_FORMAT_RESPONSE,
            //nUNSUCCESS_RESPONSE,
            nERROR_CONFIG_FILE,
            nERROR_THREAD_CONFIG_FILE,
            nERROR_CONNECTING_DB,
            //nERROR_NO_LIST_RECEIVED,
            //nERROR_READING_ASYNC,
            //nERROR_CPAP_SAVE_FAILED,
            nERROR_CANNOT_CREATE_FOLDER,
            nERROR_CANNOT_MOVE_FILE,
            nERROR_CANNOT_DELETE_FILE,
            nERROR_WAITALL,
            nERROR_SAVE_DATAFILE
        }

        public string[] EventMessages = null;

        public CLogEvent()
        {
            LoadEventMessages();
        }

        /// <summary>
        /// Preload event message
        /// </summary>
        public void LoadEventMessages()
        {
            int nMessageCount = (int)Enum.GetValues(typeof(EventMessage)).Cast<EventMessage>().Max();

            EventMessages = new string[nMessageCount + 1];
            EventMessages[(int)EventMessage.nDETAIL_MESSAGE] = String.Empty;
            EventMessages[(int)EventMessage.nSERVICE_STARTING] = "RevampPhilipsService Starting...";
            EventMessages[(int)EventMessage.nSUCCESS_CONN_DB] = "Successfully connected to database.";
            EventMessages[(int)EventMessage.nSWITCH_TO_CONFIG] = "Unable to load system settings from database. Switching to config file...";
            EventMessages[(int)EventMessage.nSWITCH_TO_DEFAULT_INTERVALS] = "Unable to read timer intervals from config file. Switching to default values...";
            EventMessages[(int)EventMessage.nTIMER_START] = "OnTimer Start";
            EventMessages[(int)EventMessage.nTIMER_DONE] = "OnTimer Done";
            //EventMessages[(int)EventMessage.nRESMED_AVX_UNAVAILABLE] = "Resmed AVX API is Unavailable. Do not process data for now and exit.";
            EventMessages[(int)EventMessage.nSEARCHING_AVAILABLE_FILES] = "Searching for available files...";
            EventMessages[(int)EventMessage.nNO_AVAILABLE_FILES] = "The file(s) for today has not been generated yet or they were already processed. Nothing to process for now.";
            //EventMessages[(int)EventMessage.nINVALID_FORMAT_RESPONSE] = "Service response in invalid format.";
            //EventMessages[(int)EventMessage.nUNSUCCESS_RESPONSE] = "Response from Resmed AVX with status UNSUCCESS";
            EventMessages[(int)EventMessage.nERROR_CONFIG_FILE] = "An error occurred while accessing the Revamp service configuration file. Unable to process clinic data!";
            EventMessages[(int)EventMessage.nERROR_THREAD_CONFIG_FILE] = "An thread error occurred while accessing the Revamp service configuration file.";
            EventMessages[(int)EventMessage.nERROR_CONNECTING_DB] = "An error occurred while connecting to the database.";
            //EventMessages[(int)EventMessage.nERROR_NO_LIST_RECEIVED] = "No list receive.";
            //EventMessages[(int)EventMessage.nERROR_READING_ASYNC] = "Error while reading main reponse async.";
            //EventMessages[(int)EventMessage.nERROR_CPAP_SAVE_FAILED] = "Unable to save CPAP data to database.";
            EventMessages[(int)EventMessage.nERROR_CANNOT_CREATE_FOLDER] = "Unable to create processed folder.";
            EventMessages[(int)EventMessage.nERROR_CANNOT_MOVE_FILE] = "Unable to move file to processed folder.";
            EventMessages[(int)EventMessage.nERROR_CANNOT_DELETE_FILE] = "Unable to delete working file.";
            EventMessages[(int)EventMessage.nERROR_WAITALL] = "Error while waiting for signal from all threads. Try increasing the Capacity List setting in the DB. As result, the service will create fewer threats with more data and the WaitAll process can wait for all signals.";
            EventMessages[(int)EventMessage.nERROR_SAVE_DATAFILE] = "Error while performing file copy to database.";

        }

        /// <summary>
        /// Log an event to the application event log
        /// </summary>
        /// <param name="eMsg"></param>
        /// <param name="etType"></param>
        public void LogEvent(EventMessage eMsg, EventLogEntryType etType)
        {
            string strSource = "RevampPhilipsService";
            string strLog = "Application";
            string strMessage = String.Empty;

            //chweck to see if the event source is registered on the local computer
            if (!EventLog.SourceExists(strSource))
            {
                EventLog.CreateEventSource(strSource, strLog);
            }

            strMessage = EventMessages[(int)eMsg];

            //log the event
            EventLog.WriteEntry(strSource, strMessage, etType);
        }

        public void LogEvent(string strMessage, EventLogEntryType etType)
        {
            string strSource = "RevampPhilipsService";
            string strLog = "Application";

            //chweck to see if the event source is registered on the local computer
            if (!EventLog.SourceExists(strSource))
            {
                EventLog.CreateEventSource(strSource, strLog);
            }
            
            //log the event
            EventLog.WriteEntry(strSource, strMessage, etType);
        }
    }
}
