﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace RevampApi.Models
{
    /// <summary>
    /// The response to the Patient Lookup will take this form
    /// </summary>
    public class PatientLookupResponse : CResponse
    {
        /// <summary>
        /// Count of records found after lookingup the patient in the external vendor service
        /// </summary>
        public long recordCount { set; get; }

        /// <summary>
        /// Constructor of the Patient lookup response
        /// </summary>
        public PatientLookupResponse()
        {
            recordCount = 0;
            this.statusCode = 0;
            this.statusComment = String.Empty;
        }

        /// <summary>
        /// Constructor of the Patient lookup response
        /// </summary>
        /// <param name="lRecordCount"></param>
        /// <param name="lStatusCode"></param>
        /// <param name="strStatusComment"></param>
        public PatientLookupResponse(long lRecordCount, long lStatusCode, string strStatusComment)
        {
            recordCount = lRecordCount;
            this.statusCode = lStatusCode;
            this.statusComment = strStatusComment;
        }
    }
}