﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace RevampApi.Models
{
    /// <summary>
    /// Response after the Patient ID search
    /// </summary>
    public class PatientIDSearchResponse : CResponse
    {
        /// <summary>
        /// List of results
        /// </summary>
        public List<PatientIDSearchResult> searchResult { set; get; }

        /// <summary>
        /// Construct PatientID Search Response
        /// </summary>
        public PatientIDSearchResponse()
        {
            searchResult = new List<PatientIDSearchResult>();
            statusCode = 0;
            statusComment = String.Empty;
        }
    }

    /// <summary>
    /// Search results
    /// </summary>
    public class PatientIDSearchResult
    {
        /// <summary>
        /// Patient data
        /// </summary>
        public string patientData { set; get; }

        /// <summary>
        /// External Patient ID
        /// </summary>
        public string externalPatientID { set; get; }
    }

}