﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;

using RevampApi.Models;

namespace RevampApi.Controllers
{
    /// <summary>
    /// Service Controller
    /// </summary>
    public class ServiceController : ApiController
    {
        /// <summary>
        /// Check if the REVAMPv2 API is active
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public string IsActive()
        {
            return "REVAMPv2 API is active.";
        }

        /// <summary>
        /// Check if the Vendor's API is active
        /// </summary>
        /// <param name="VendorID"></param>
        /// <returns></returns>
        [HttpGet]
        public ServiceStatus IsVendorAPIActive(string VendorID)
        {
            CService srv = new CService();
            return srv.IsVendorAPIActive(VendorID);
        }
    }
}
