﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;

using System.Net.Http.Headers;
//using Newtonsoft.Json;

using RevampApi.Models;

namespace RevampApi.Controllers
{
    /// <summary>
    /// Patient controller
    /// </summary>
    public class PatientsController : ApiController
    {
        /// <summary>
        /// TODO: REMOVE THIS FUNCTION
        /// </summary>
        /// <param name="strPatientID"></param>
        /// <returns></returns>
        public Patient GetPatient(string strPatientID)
        {
            Patient p = new Patient();
            string strKey = String.Empty;
            switch (strPatientID)
            {
                case "AAAAA": strKey = "11111";
                    break;
                case "BBBBB": strKey = "22222";
                    break;
                case "CCCCC": strKey = "33333";
                    break;
            }

            using (var client = new HttpClient())
            {
                client.BaseAddress = new Uri("http://localhost:49979/");
                client.DefaultRequestHeaders.Accept.Clear();
                client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/json"));
                HttpResponseMessage response = null;

                try
                {
                    //response = client.GetAsync("api/service/getStatus/").Result;
                    //if (response.IsSuccessStatusCode)
                    //{
                    //    string strValue = response.Content.ReadAsAsync<string>().Result;
                    //    Console.WriteLine("{0}", strValue);
                    //}
                    //else
                    //{
                    //    Console.WriteLine("Error. {0}", response.ReasonPhrase);
                    //}

                    response = client.GetAsync("api/patients/getPatient?strENC=" + strKey).Result;
                    if (response.IsSuccessStatusCode)
                    {
                        Patient remotePatient = response.Content.ReadAsAsync<Patient>().Result;
                        p.FirstName = remotePatient.FirstName;
                        p.LastName = remotePatient.LastName;
                    }
                    else
                    {
                        //ERROR -> response.ReasonPhrase
                    }
                }
                catch (System.Net.Http.HttpRequestException e)
                {
                    Console.WriteLine(e.Message);
                    Console.WriteLine(e.InnerException.Message);
                }
            }
            return p;
        }

        /// <summary>
        /// Lookup Patient data in the corresponding API of the vendor
        /// </summary>
        /// <param name="PatientID"></param>
        /// <returns></returns>
        [HttpGet]
        public PatientLookupResponse LookupPatient(string PatientID)
        {
            CPatients p = new CPatients();
            return p.LookupPatient(PatientID);
        }

        /// <summary>
        /// Search for the ID of the patient with the vendor
        /// </summary>
        /// <param name="VendorID"></param>
        /// <param name="SearchKeys"></param>
        /// <returns></returns>
        [HttpGet]
        public PatientIDSearchResponse SearchPatientID(string VendorID, [FromUri] string[] SearchKeys)
        {
            //convert SearchKeys string array to List of string
            List<string> lstSearchKeys = new List<string>(SearchKeys);

            CPatients p = new CPatients();
            return p.SearchPatientUniqueIdentifier(VendorID, lstSearchKeys);
        }

    }
}
