﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Web.Cors;
using System.Web.Http.Cors;
using System.Net.Http;
using System.Threading;
using System.Threading.Tasks;

namespace RevampApi
{
    /// <summary>
    /// Custom policy provider
    /// </summary>
    public class CustomPolicyProvider : ICorsPolicyProvider
    {
        CorsPolicy policy;

        /// <summary>
        /// Construct custom policy provider
        /// </summary>
        /// <param name="policy"></param>
        public CustomPolicyProvider(CorsPolicy policy)
        {
            this.policy = policy;
        }

        /// <summary>
        /// Get CORS policy
        /// </summary>
        /// <param name="request"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        public Task<CorsPolicy> GetCorsPolicyAsync(HttpRequestMessage request, CancellationToken cancellationToken)
        {
            return Task.FromResult(this.policy);
        }
    }
}