﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Configuration;

namespace RevampApi.App_Code.AppModel
{
    /// <summary>
    /// Factory to manage all possible vendor services
    /// </summary>
    public class CVendorServiceFactory
    {
        private string m_strPHILIPS = String.Empty;
        private string m_strRESMED_AVX = String.Empty;

        /// <summary>
        /// Create vendor service factory and load service codes from configuration
        /// </summary>
        public CVendorServiceFactory()
        {
            m_strPHILIPS = ConfigurationManager.AppSettings["PHILIPS_CODE"];
            m_strRESMED_AVX = ConfigurationManager.AppSettings["RESMED_AVX_CODE"];
        }

        /// <summary>
        /// Create the corresponding service depending on the Vendor ID
        /// </summary>
        /// <param name="strVendorID"></param>
        /// <returns></returns>
        public CVendorService CreateService(string strVendorID)
        {
            CVendorService srvVnd = null;

            if (strVendorID == m_strPHILIPS)
            {
                srvVnd = new CPhilipsService();
            }
            else if (strVendorID == m_strRESMED_AVX)
            {
                srvVnd = new CResmedAVXService();
            }

            return srvVnd;
        }
    }
}