﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using RevampApi.Models;

namespace RevampApi.App_Code.AppModel
{
    /// <summary>
    /// Abstract Vendor Service
    /// </summary>
    public abstract class CVendorService
    {
        /// <summary>
        /// Is the service active?
        /// </summary>
        /// <returns></returns>
        public abstract ServiceStatus IsActive();

        /// <summary>
        /// Search for a patient and Get CPAP data.
        /// </summary>
        /// <param name="strPatientID"></param>
        /// <param name="strExternalID"></param>
        /// <param name="dtProcessDate"></param>
        /// <param name="strGap"></param>
        /// <returns></returns>
        public abstract PatientLookupResponse LookupPatient(string strPatientID, 
                                                            string strExternalID,
                                                            DateTime dtProcessDate,
                                                            string strGap);

        /// <summary>
        /// Search for the vendor's Patient Unique Identifier.
        /// </summary>
        /// <param name="lstPatientData"></param>
        /// <returns></returns>
        public abstract PatientIDSearchResponse SearchPatientID(List<string> lstPatientData);
    }
}