﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Configuration;
using System.Data;

using DataAccess;

using RevampApi.Models;

namespace RevampApi.App_Code.AppModel
{
    /// <summary>
    /// Implement Philips.
    /// </summary>
    public class CPhilipsService: CVendorService
    {
        /// <summary>
        /// Is the service active?
        /// </summary>
        /// <returns></returns>
        public override ServiceStatus IsActive()
        {
            ServiceStatus srvStatus = new ServiceStatus();
            srvStatus.active = "true";
            srvStatus.comment = "";
            srvStatus.statusCode = 0;
            srvStatus.statusComment = String.Empty;

            return srvStatus;
        }

        /// <summary>
        /// Search for a patient and Get CPAP data.
        /// </summary>
        /// <param name="strPatientID"></param>
        /// <param name="strExternalID"></param>
        /// <param name="dtProcessDate"></param>
        /// <param name="strGap"></param>
        /// <returns></returns>
        public override PatientLookupResponse LookupPatient(string strPatientID, string strExternalID, DateTime dtProcessDate, string strGap)
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// Search for the vendor's Patient Unique Identifier.
        /// </summary>
        /// <param name="lstPatientData"></param>
        /// <returns></returns>
        public override PatientIDSearchResponse SearchPatientID(List<string> lstPatientData)
        {
            #region local variables
            CDataConnection cnn = null;
            string strConnectionString = String.Empty;
            bool bAudit = true;

            long lStatusCode = 0;
            string strStatusComment = String.Empty;

            PatientIDSearchResponse rsp = new PatientIDSearchResponse();
            string strMsg = String.Empty;

            string strDeviceSerialNo = String.Empty;
            //string strFirstName = String.Empty;
            //string strLastName = String.Empty;
            string strClinicID = String.Empty;

            string strResultExternalID = String.Empty;
            string strResultPatientData = String.Empty;
            #endregion

            //validate lstPatientData
            if (lstPatientData.Count != 2)
            {
                rsp.statusCode = 1;
                rsp.statusComment = "Wrong number of arguments";
                return rsp;
            }

            //load search keys
            strDeviceSerialNo = lstPatientData[0];
            //strFirstName = lstPatientData[1];
            //strLastName = lstPatientData[2];
            strClinicID = lstPatientData[1];

            //config settings
            strConnectionString = ConfigurationManager.ConnectionStrings["DBConnString"].ConnectionString;
            bAudit = (ConfigurationManager.AppSettings["AUDIT"] == "1") ? true : false;

            //connect to data source
            cnn = new CDataConnection();
            if (!cnn.Connect(strConnectionString, (int)DataConnectionType.Oracle, bAudit))
            {
                rsp.statusCode = 1;
                rsp.statusComment = "Error Connecting to Data Source";
                return rsp;
            }

            //parameter list (BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);
            CDataParameterList pList = new CDataParameterList(String.Empty, String.Empty, 0);

            //add params for the DB stored procedure call
            pList.AddInputParameter("pi_vDeviceSN", strDeviceSerialNo);
            //pList.AddInputParameter("pi_vFirstName", strFirstName);
            //pList.AddInputParameter("pi_vLastName", strLastName);
            pList.AddInputParameter("pi_vClinicID", strClinicID);

            CDataSet cds = new CDataSet();
            DataSet ds = cds.GetOracleDataSet(cnn,
                                              "PCK_API.SearchExternalIDWithPhilips",
                                              pList,
                                              out lStatusCode,
                                              out strStatusComment);

            rsp.statusCode = lStatusCode;
            rsp.statusComment = strStatusComment;

            //check response
            if (lStatusCode == 0)
            {
                if (ds != null)
                {
                    foreach (DataTable table in ds.Tables)
                    {
                        foreach (DataRow row in table.Rows)
                        {
                            if (!row.IsNull("EXTERNAL_ID"))
                            {
                                strResultExternalID = row["EXTERNAL_ID"].ToString();
                            }

                            if (!row.IsNull("PATIENT_DATA"))
                            {
                                strResultPatientData = row["PATIENT_DATA"].ToString();
                            }

                            rsp.searchResult.Add(new PatientIDSearchResult() { patientData = strResultPatientData, externalPatientID = strResultExternalID });

                        }
                    }
                }
            }

            //CLOSE CONNECTION
            cnn.Close();
            
            if (rsp.statusCode == 0 && rsp.searchResult.Count() == 0)
            {
                rsp.statusComment = "No results";
            }

            return rsp;

        }
        
    }
}