﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Configuration;
using System.Data;

using DataAccess;

using RevampApi.App_Code.AppModel;
using RevampApi.Models;

namespace RevampApi
{

    /// <summary>
    /// Patient controller manager
    /// </summary>
    public class CPatients
    {
        /// <summary>
        /// Lookup Patient.
        /// </summary>
        /// <param name="strPatientID"></param>
        /// <returns></returns>
        public PatientLookupResponse LookupPatient(string strPatientID)
        {
            string strExternalID = String.Empty;
            string strVendorID = String.Empty;
            DateTime dtProcessDate = DateTime.Now;
            string strGap = String.Empty;

            CVendorServiceFactory vndSrvFactory = null;
            CVendorService vndSrv = null;

            long lStatusCode = 0;
            string strStatusComment = String.Empty;

            //get patient external id...
            strExternalID = GetPatientExternalID(strPatientID, ref strVendorID, ref dtProcessDate, ref strGap, ref lStatusCode, ref strStatusComment);
            if (lStatusCode != 0)
            {
                return new PatientLookupResponse(0, lStatusCode, strStatusComment);
            }
            //cannot process if there is no External ID
            if(String.IsNullOrEmpty(strExternalID))
            {
                lStatusCode = 1;
                strStatusComment = "External ID not found";
                return new PatientLookupResponse(0, lStatusCode, strStatusComment);
            }
            //nothing to process if there is no CPAP gap
            if (Convert.ToInt64(strGap) == 0)
            {
                lStatusCode = 0;
                strStatusComment = "No CPAP gap found";
                return new PatientLookupResponse(0, lStatusCode, strStatusComment);
            }

            
            //get vendor service...
            //and lookup patient using the external id...
            vndSrvFactory = new CVendorServiceFactory();
            vndSrv = vndSrvFactory.CreateService(strVendorID);

            //lRecordCount = vndSrv.LookupPatient(strPatientID, strExternalID, strGap);
            return vndSrv.LookupPatient(strPatientID, strExternalID, dtProcessDate, strGap);
            
            //return new PatientLookupResponse(lRecordCount, lStatusCode, strStatusComment);
        }


        /// <summary>
        /// Get the ExternalID of the patient from the REVAMP database.
        /// </summary>
        /// <param name="strPatientID"></param>
        /// <param name="strVendorID"></param>
        /// <param name="dtProcessDate"></param>
        /// <param name="strGap"></param>
        /// <param name="lStatusCode"></param>
        /// <param name="strStatusComment"></param>
        /// <returns></returns>
        private string GetPatientExternalID(string strPatientID, 
                                            ref string strVendorID, 
                                            ref DateTime dtProcessDate,
                                            ref string strGap,
                                            ref long lStatusCode, 
                                            ref string strStatusComment)
        {
            CDataConnection cnn = null;
            string strConnectionString = String.Empty;
            bool bAudit = true;

            string strResultExternalID = String.Empty;
            string strResultVendorID = String.Empty;
            string strResultGap = String.Empty;

            //config settings
            strConnectionString = ConfigurationManager.ConnectionStrings["DBConnString"].ConnectionString;
            bAudit = (ConfigurationManager.AppSettings["AUDIT"] == "1") ? true : false;

            //connect to data source
            cnn = new CDataConnection();
            if (!cnn.Connect(strConnectionString, (int)DataConnectionType.Oracle, bAudit))
            {
                lStatusCode = 1;
                strStatusComment = "Error Connecting to Data Source";
                return null;
            }

            //parameter list (BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);
            CDataParameterList pList = new CDataParameterList(String.Empty, String.Empty, 0);

            //add params for the DB stored procedure call
            pList.AddInputParameter("pi_vPatientID", strPatientID);
            
            //
            CDataSet cds = new CDataSet();
            DataSet ds = cds.GetOracleDataSet(cnn,
                                              "PCK_API.GetExternalIDWithGAPRS",
                                              pList,
                                              out lStatusCode,
                                              out strStatusComment);

            //check response
            if (lStatusCode == 0)
            {
                if (ds != null)
                {
                    foreach (DataTable table in ds.Tables)
                    {
                        foreach (DataRow row in table.Rows)
                        {
                            if (!row.IsNull("EXTERNAL_ID"))
                            {
                                strResultExternalID = row["EXTERNAL_ID"].ToString();
                            }

                            if (!row.IsNull("VENDOR_ID"))
                            {
                                strResultVendorID = row["VENDOR_ID"].ToString();
                            }

                            if (!row.IsNull("PROCESS_DATE"))
                            {
                                dtProcessDate = Convert.ToDateTime(row["PROCESS_DATE"].ToString());
                            }

                            if (!row.IsNull("CPAP_GAP"))
                            {
                                strResultGap = row["CPAP_GAP"].ToString();
                            }
                        }
                    }
                }
            }
            
            //CLOSE CONNECTION
            cnn.Close();

            if (lStatusCode != 0)
            {
                return null;
            }

            strVendorID = strResultVendorID;
            strGap = strResultGap;

            return strResultExternalID;

        }

        /// <summary>
        /// Search for the patient unique identifier used by the vendor
        /// </summary>
        /// <param name="strVendorID"></param>
        /// <param name="lstSearchKeys"></param>
        /// <returns></returns>
        public PatientIDSearchResponse SearchPatientUniqueIdentifier(string strVendorID,
                                                                     List<string> lstSearchKeys)
        {
            string strExternalD = String.Empty; //Vendor's Patient ID
            
            CVendorServiceFactory vndSrvFactory = null;
            CVendorService vndSrv = null;

            //get vendor service...
            vndSrvFactory = new CVendorServiceFactory();
            vndSrv = vndSrvFactory.CreateService(strVendorID);

            return vndSrv.SearchPatientID(lstSearchKeys);

        }
    }
}