﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Data;

using Newtonsoft.Json;

using DataAccess;

namespace RevampApi.App_Code.AppModel
{
    /// <summary>
    /// CPAP
    /// </summary>
    public class CCPAP
    {
        /// <summary>
        /// External unique ID from vendor
        /// </summary>
        public string ExternalID { set; get; }

        /// <summary>
        /// Patient ID
        /// </summary>
        public string PatientID { set; get; }

        /// <summary>
        /// System time of data receipt to AirView
        /// </summary>
        public string ReceiptTime { set; get; }

        /// <summary>
        /// The day this data is for
        /// </summary>
        public string TherapyDate { set; get; }

        /// <summary>
        /// Minutes of use
        /// </summary>
        public string MinOfUse { set; get; }

        /// <summary>
        /// Therapy mode that device was in on this day
        /// </summary>
        public string DeviceMode { set; get; }

        /// <summary>
        /// Serial number of the device used by the patient on this day
        /// </summary>
        public string DeviceSerialNo { set; get; }

        /// <summary>
        /// Type of device used by the patient on this day
        /// </summary>
        public string DeviceType { set; get; }

        /// <summary>
        /// Description of type of device used by patient on this day
        /// </summary>
        public string DeviceTypeDesc { set; get; }

        /// <summary>
        /// The set pressure in cmH2O
        /// </summary>
        public string SettingPress { set; get; }

        /// <summary>
        /// The maximum allowable pressure in cmH2O
        /// </summary>
        public string SettingMaxPress { set; get; }

        /// <summary>
        /// The minimum allowable pressure in cmH2O
        /// </summary>
        public string SettingMinPress { set; get; }

        /// <summary>
        /// Expiratory Pressure Relief type
        /// </summary>
        public string SettingEPRType { set; get; }

        /// <summary>
        /// Expiratory Pressure Relief level (relevant if EPRType not OFF)
        /// </summary>
        public string SettingEPRLevel { set; get; }

        /// <summary>
        /// Desaturation Rule Threshold setting
        /// </summary>
        public string SettingODIThreshold { set; get; }

        /// <summary>
        /// Intelligent Backup Rate Enable setting
        /// </summary>
        public string SettingIBREnable { set; get; }

        /// <summary>
        /// Auto EPAP Enable setting
        /// </summary>
        public string SettingEPAPAutoEnable { set; get; }

        /// <summary>
        /// Inspiratory Positive Airway Pressure setting
        /// </summary>
        public string SettingIPAP { set; get; }

        /// <summary>
        /// Expiratory Positive Airway Pressure setting
        /// </summary>
        public string SettingEPAP { set; get; }

        /// <summary>
        /// AutoSet Response Setting On (Soft) / Off (Standard)
        /// </summary>
        public string SettingAutoSetResponse { set; get; }

        /// <summary>
        /// Minimum EPAP setting
        /// </summary>
        public string SettingMinEPAP { set; get; }

        /// <summary>
        /// Maximum EPAP setting
        /// </summary>
        public string SettingMaxEPAP { set; get; }

        /// <summary>
        /// Minimum Pressure Support setting
        /// </summary>
        public string SettingMinPS { set; get; }

        /// <summary>
        /// Maximum Pressure Support setting
        /// </summary>
        public string SettingMaxPS { set; get; }

        /// <summary>
        /// 95% of target IPAP in cmH2O
        /// </summary>
        public string TGTIPAP_95 { set; get; }

        /// <summary>
        /// Median target IPAP in cmH2O
        /// </summary>
        public string TGTIPAP_50 { set; get; }

        /// <summary>
        /// Maximum target IPAP in cmH2O
        /// </summary>
        public string TGTIPAP_MAX { set; get; }

        /// <summary>
        /// 95% of target EPAP in cmH2O
        /// </summary>
        public string TGTEPAP_95 { set; get; }

        /// <summary>
        /// Median target EPAP in cmH2O
        /// </summary>
        public string TGTEPAP_50 { set; get; }

        /// <summary>
        /// Maximum target EPAP in cmH2O
        /// </summary>
        public string TGTEPAP_MAX { set; get; }

        /// <summary>
        /// 95% of leak in liters per second
        /// </summary>
        public string LEAK_95 { set; get; }

        /// <summary>
        /// Median leak in liters per second
        /// </summary>
        public string LEAK_50 { set; get; }

        /// <summary>
        /// Maximum leak in liters per second
        /// </summary>
        public string LEAK_MAX { set; get; }

        /// <summary>
        /// 95% respiratory rate in breaths per minute
        /// </summary>
        public string RESPRATE_95 { set; get; }

        /// <summary>
        /// Median respiratory rate in breaths per minute
        /// </summary>
        public string RESPRATE_50 { set; get; }

        /// <summary>
        /// Maximum respiratory rate in breaths per minute
        /// </summary>
        public string RESPRATE_MAX { set; get; }

        /// <summary>
        /// 95% of I:E ratio
        /// </summary>
        public string IERATIO_95 { set; get; }

        /// <summary>
        /// Median I:E ratio
        /// </summary>
        public string IERATIO_50 { set; get; }

        /// <summary>
        /// Maximum I:E ratio
        /// </summary>
        public string IERATIO_MAX { set; get; }

        /// <summary>
        /// 95% of minute ventilation in liters per minute
        /// </summary>
        public string MINUTEVENT_95 { set; get; }

        /// <summary>
        /// Median minute ventilation in liters per minute
        /// </summary>
        public string MINUTEVENT_50 { set; get; }

        /// <summary>
        /// Maximum minute ventilation in liters per minute
        /// </summary>
        public string MINUTEVENT_MAX { set; get; }

        /// <summary>
        /// 95% of tidal volume in liters
        /// </summary>
        public string TIDALVOL_95 { set; get; }

        /// <summary>
        /// Median tidal volume in liters
        /// </summary>
        public string TIDALVOL_50 { set; get; }

        /// <summary>
        /// Maximum tidal volume in liters
        /// </summary>
        public string TIDALVOL_MAX { set; get; }

        /// <summary>
        /// 95%
        /// </summary>
        public string SPO2_95 { set; get; }

        /// <summary>
        /// 50%
        /// </summary>
        public string SPO2_50 { set; get; }

        /// <summary>
        /// SpO2 metrics minimum
        /// </summary>
        public string SPO2_MIN { set; get; }

        /// <summary>
        /// SpO2 minutes under the 88% threshold
        /// </summary>
        public string SPO2_minBelow88 { set; get; }

        /// <summary>
        /// SpO2 seconds under dynamic threshold
        /// </summary>
        public string SPO2_secBelowDYNAT { set; get; }

        /// <summary>
        /// 95% of alveolar ventilation in liters per minute
        /// </summary>
        public string ALVEOLARVENT_95 { set; get; }

        /// <summary>
        /// Median alveolar ventilation in liters per minute
        /// </summary>
        public string ALVEOLARVENT_50 { set; get; }

        /// <summary>
        /// Maximum alveolar ventilation in liters per minute
        /// </summary>
        public string ALVEOLARVENT_MAX { set; get; }

        /// <summary>
        /// Percentage of spontaneous triggered breaths
        /// </summary>
        public string SpontTriggBreaths { set; get; }

        /// <summary>
        /// Percentage of spontaneous cycled breaths
        /// </summary>
        public string SpontCycledBreaths { set; get; }

        /// <summary>
        /// Apnea–hypopnea index in events per hour
        /// </summary>
        public string AHI { set; get; }

        /// <summary>
        /// Hypopnea index in events per hour
        /// </summary>
        public string HI { set; get; }

        /// <summary>
        /// Apnea index in events per hour
        /// </summary>
        public string AI { set; get; }

        /// <summary>
        /// Obstructive apnea index in events per hour
        /// </summary>
        public string OAI { set; get; }

        /// <summary>
        /// Central apnea index in events per hour
        /// </summary>
        public string CAI { set; get; }

        /// <summary>
        /// Unknown apnea index in events per hour
        /// </summary>
        public string UAI { set; get; }

        /// <summary>
        /// Oxygen Desaturation Index
        /// </summary>
        public string ODI { set; get; }

        /// <summary>
        /// Cheyne Stokes Respiration in minutes
        /// </summary>
        public string CSR { set; get; }

        /// <summary>
        /// Respiratory Effort Related Arousal in events per hour
        /// </summary>
        public string RERA { set; get; }

        /// <summary>
        /// Type of humidifier used on this day – Endcap, internal, or
        /// external
        /// </summary>
        public string Humidifier { set; get; }

        /// <summary>
        /// Type of heated tube used on this day – None, 15mm
        /// (ClimateLine) or 19mm (ClimateLine Max)
        /// </summary>
        public string HeatedTube { set; get; }

        /// <summary>
        /// Absolute ambient humidity for the session in milligrams of
        /// water per liter.
        /// </summary>
        public string AMBHumidity { set; get; }


        /// <summary>
        /// Usage statistics. Mask On/Off
        /// </summary>
        public List<CCPAPUsage> Usage { set; get; }

        /// <summary>
        /// Construct and init
        /// </summary>
        public CCPAP()
        {
            ExternalID = null;
            PatientID = null;
            ReceiptTime = null;
            TherapyDate = null;
            MinOfUse = null;
            DeviceMode = null;
            DeviceSerialNo = null;
            DeviceType = null;
            DeviceTypeDesc = null;
            SettingPress = null;
            SettingMaxPress = null;
            SettingMinPress = null;
            SettingEPRType = null;
            SettingEPRLevel = null;
            SettingODIThreshold = null;
            SettingIBREnable = null;
            SettingEPAPAutoEnable = null;
            SettingIPAP = null;
            SettingEPAP = null;
            SettingAutoSetResponse = null;
            SettingMinEPAP = null;
            SettingMaxEPAP = null;
            SettingMinPS = null;
            SettingMaxPS = null;
            TGTIPAP_95 = null;
            TGTIPAP_50 = null;
            TGTIPAP_MAX = null;
            TGTEPAP_95 = null;
            TGTEPAP_50 = null;
            TGTEPAP_MAX = null;
            LEAK_95 = null;
            LEAK_50 = null;
            LEAK_MAX = null;
            RESPRATE_95 = null;
            RESPRATE_50 = null;
            RESPRATE_MAX = null;
            IERATIO_95 = null;
            IERATIO_50 = null;
            IERATIO_MAX = null;
            MINUTEVENT_95 = null;
            MINUTEVENT_50 = null;
            MINUTEVENT_MAX = null;
            TIDALVOL_95 = null;
            TIDALVOL_50 = null;
            TIDALVOL_MAX = null;
            SPO2_95 = null;
            SPO2_50 = null;
            SPO2_MIN = null;
            SPO2_minBelow88 = null;
            SPO2_secBelowDYNAT = null;
            ALVEOLARVENT_95 = null;
            ALVEOLARVENT_50 = null;
            ALVEOLARVENT_MAX = null;
            SpontTriggBreaths = null;
            SpontCycledBreaths = null;
            AHI = null;
            HI = null;
            AI = null;
            OAI = null;
            CAI = null;
            UAI = null;
            ODI = null;
            CSR = null;
            RERA = null;
            Humidifier = null;
            HeatedTube = null;
            AMBHumidity = null;

            Usage = new List<CCPAPUsage>(); //Mask On/Off
        }

        /// <summary>
        /// Save CPAP data.
        /// </summary>
        /// <param name="cnn"></param>
        /// <param name="lStatusCode"></param>
        /// <param name="strStatusComment"></param>
        /// <returns></returns>
        public int Save(ref CDataConnection cnn, ref long lStatusCode, ref string strStatusComment)
        {
            int nResult = 0;

            string strUsage = JsonConvert.SerializeObject(this.Usage);

            //parameter list (BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);
            CDataParameterList plist = new CDataParameterList(String.Empty, String.Empty, 0);

            //add params for the DB stored procedure call
            plist.AddInputParameter("pi_vExternalID", this.ExternalID);
            plist.AddInputParameter("pi_vPatientID", this.PatientID);
            plist.AddInputParameter("pi_vReceiptTime", this.ReceiptTime);
            plist.AddInputParameter("pi_vTherapyDate", this.TherapyDate);
            plist.AddInputParameter("pi_vMinOfUse", this.MinOfUse);
            plist.AddInputParameter("pi_vDeviceMode", this.DeviceMode);
            plist.AddInputParameter("pi_vDeviceSerialNo", this.DeviceSerialNo);
            plist.AddInputParameter("pi_vDeviceType", this.DeviceType);
            plist.AddInputParameter("pi_vDeviceTypeDesc", this.DeviceTypeDesc);
            plist.AddInputParameter("pi_vSettingPress", this.SettingPress);
            plist.AddInputParameter("pi_vSettingMaxPress", this.SettingMaxPress);
            plist.AddInputParameter("pi_vSettingMinPress", this.SettingMinPress);
            plist.AddInputParameter("pi_vSettingEPRType", this.SettingEPRType);
            plist.AddInputParameter("pi_vSettingEPRLevel", this.SettingEPRLevel);
            plist.AddInputParameter("pi_vSettingODIThreshold", this.SettingODIThreshold);
            plist.AddInputParameter("pi_vSettingIBREnable", this.SettingIBREnable);
            plist.AddInputParameter("pi_vSettingEPAPAutoEnable", this.SettingEPAPAutoEnable);
            plist.AddInputParameter("pi_vSettingIPAP", this.SettingIPAP);
            plist.AddInputParameter("pi_vSettingEPAP", this.SettingEPAP);
            plist.AddInputParameter("pi_vSettingAutoSetResponse", this.SettingAutoSetResponse);
            plist.AddInputParameter("pi_vSettingMinEPAP", this.SettingMinEPAP);
            plist.AddInputParameter("pi_vSettingMaxEPAP", this.SettingMaxEPAP);
            plist.AddInputParameter("pi_vSettingMinPS", this.SettingMinPS);
            plist.AddInputParameter("pi_vSettingMaxPS", this.SettingMaxPS);
            plist.AddInputParameter("pi_vTGTIPAP_95", this.TGTIPAP_95);
            plist.AddInputParameter("pi_vTGTIPAP_50", this.TGTIPAP_50);
            plist.AddInputParameter("pi_vTGTIPAP_MAX", this.TGTIPAP_MAX);
            plist.AddInputParameter("pi_vTGTEPAP_95", this.TGTEPAP_95);
            plist.AddInputParameter("pi_vTGTEPAP_50", this.TGTEPAP_50);
            plist.AddInputParameter("pi_vTGTEPAP_MAX", this.TGTEPAP_MAX);
            plist.AddInputParameter("pi_vLEAK_95", this.LEAK_95);
            plist.AddInputParameter("pi_vLEAK_50", this.LEAK_50);
            plist.AddInputParameter("pi_vLEAK_MAX", this.LEAK_MAX);
            plist.AddInputParameter("pi_vRESPRATE_95", this.RESPRATE_95);
            plist.AddInputParameter("pi_vRESPRATE_50", this.RESPRATE_50);
            plist.AddInputParameter("pi_vRESPRATE_MAX", this.RESPRATE_MAX);
            plist.AddInputParameter("pi_vIERATIO_95", this.IERATIO_95);
            plist.AddInputParameter("pi_vIERATIO_50", this.IERATIO_50);
            plist.AddInputParameter("pi_vIERATIO_MAX", this.IERATIO_MAX);
            plist.AddInputParameter("pi_vMINUTEVENT_95", this.MINUTEVENT_95);
            plist.AddInputParameter("pi_vMINUTEVENT_50", this.MINUTEVENT_50);
            plist.AddInputParameter("pi_vMINUTEVENT_MAX", this.MINUTEVENT_MAX);
            plist.AddInputParameter("pi_vTIDALVOL_95", this.TIDALVOL_95);
            plist.AddInputParameter("pi_vTIDALVOL_50", this.TIDALVOL_50);
            plist.AddInputParameter("pi_vTIDALVOL_MAX", this.TIDALVOL_MAX);
            plist.AddInputParameter("pi_vSPO2_95", this.SPO2_95);
            plist.AddInputParameter("pi_vSPO2_50", this.SPO2_50);
            plist.AddInputParameter("pi_vSPO2_MIN", this.SPO2_MIN);
            plist.AddInputParameter("pi_vSPO2_minBelow88", this.SPO2_minBelow88);
            plist.AddInputParameter("pi_vSPO2_secBelowDYNAT", this.SPO2_secBelowDYNAT);
            plist.AddInputParameter("pi_vALVEOLARVENT_95", this.ALVEOLARVENT_95);
            plist.AddInputParameter("pi_vALVEOLARVENT_50", this.ALVEOLARVENT_50);
            plist.AddInputParameter("pi_vALVEOLARVENT_MAX", this.ALVEOLARVENT_MAX);
            plist.AddInputParameter("pi_vSpontTriggBreaths", this.SpontTriggBreaths);
            plist.AddInputParameter("pi_vSpontCycledBreaths", this.SpontCycledBreaths);
            plist.AddInputParameter("pi_vAHI", this.AHI);
            plist.AddInputParameter("pi_vHI", this.HI);
            plist.AddInputParameter("pi_vAI", this.AI);
            plist.AddInputParameter("pi_vOAI", this.OAI);
            plist.AddInputParameter("pi_vCAI", this.CAI);
            plist.AddInputParameter("pi_vUAI", this.UAI);
            plist.AddInputParameter("pi_vODI", this.ODI);
            plist.AddInputParameter("pi_vCSR", this.CSR);
            plist.AddInputParameter("pi_vRERA", this.RERA);
            plist.AddInputParameter("pi_vHumidifier", this.Humidifier);
            plist.AddInputParameter("pi_vHeatedTube", this.HeatedTube);
            plist.AddInputParameter("pi_vAMBHumidity", this.AMBHumidity);
            plist.AddInputParameter("pi_vUsage", strUsage);

            //
            CDataSet cds = new CDataSet();
            DataSet ds = cds.GetOracleDataSet(cnn,
                                              "PCK_XFER.ImportResmedCPAPRS",
                                              plist,
                                              out lStatusCode,
                                              out strStatusComment);

            //check response
            if (lStatusCode == 0)
            {
                if (ds != null)
                {
                    foreach (DataTable table in ds.Tables)
                    {
                        foreach (DataRow row in table.Rows)
                        {
                            if (!row.IsNull("RESULT"))
                            {
                                nResult = Convert.ToInt16(row["RESULT"].ToString());
                            }
                        }
                    }
                }
            }
            else
            {
                return -1;
            }

            return nResult;

        }
    }
}