// Karma configuration
// http://karma-runner.github.io/0.10/config/configuration-file.html

module.exports = function(config) {
    config.set({
        // base path, that will be used to resolve files and exclude
        basePath: '',

        // testing framework to use (jasmine/mocha/qunit/...)
        frameworks: ['jasmine', "requirejs"],

		plugins: [
			'karma-requirejs',
			'karma-phantomjs-launcher',
			'karma-jasmine',
			'karma-junit-reporter',
			'karma-threshold-reporter',
			'karma-ng-html2js-preprocessor',
			'karma-coverage'
		],

        // list of files / patterns to load in the browser
        files: [
            {pattern: 'app/libs/angular-mocks/js/angular-mocks.js', included: false },
            {pattern: 'app/libs/angular-sanitize/js/angular-sanitize.js', included: false },
            {pattern: 'app/libs/angular-ui-router/js/angular-ui-router.js', included: false },
			{pattern: 'app/libs/angular-busy/js/angular-busy.js', included: false },
            {pattern: 'app/**/*.js', included: false },
			{pattern: 'app/**/*.json', included: false },
            {pattern: 'test/spec/*.js', included: false },
			{pattern: 'app/src/ui-components/**/*.html', included: false },
            'test/config.js'
        ],

        // list of files / patterns to exclude
        exclude: [
            'app/scripts/config.js'
        ],

        // web server port
        port: 8888,

        colors: true,

        // level of logging
        // possible values: LOG_DISABLE || LOG_ERROR || LOG_WARN || LOG_INFO || LOG_DEBUG
        logLevel: config.LOG_INFO,

        // enable / disable watching file and executing tests whenever any file changes
        autoWatch: false,

        includeBaseline: true,

        // Start these browsers, currently available:
        // - Chrome
        // - ChromeCanary
        // - Firefox
        // - Opera
        // - Safari (only Mac)
        // - PhantomJS
        // - IE (only Windows)
        browsers: ['PhantomJS'],

        // Continuous Integration mode
        // if true, it capture browsers, run tests and exit
        singleRun: true,

        reporters: ['progress' , 'junit', 'coverage', 'threshold'],

        preprocessors: {
            'app/src/**/!(*_spec).js' : ['coverage'],
			'app/src/!templates.js' : ['coverage'],
			'app/src/ui-components/**/*.html': ['ng-html2js']
		},

        thresholdReporter: {
            statements: 0,
            branches: 0,
            functions: 0,
            lines: 0
        },

        coverageReporter: {
            reporters: [
            {  type : 'lcov', dir:'coverage/'},
            {  type : 'cobertura' }]
        },
        // the default configuration. Generates the junit test report.
        junitReporter: {
            outputFile: 'coverage/junit-test-results.xml',
            suite: ''
        }
    });
};
