#!/bin/bash

typeset confFile=$1
typeset confFileBasename=`basename $confFile`

typeset base=deployWeblogicConf
typeset deployScript=${base}.sh
typeset deployLog=${base}.log
typeset errorLog=${base}.error
typeset deploymentsDir=$VAGRANT_DIR/deployments
typeset envScript='../set.env.sh'

rm -f $errorLog
if [ -z $VAGRANT_DIR ] || [ ! -r $VAGRANT_DIR/Vagrantfile ] ; then
	echo '$VAGRANT_DIR must be defined and contain a valid Vagrantfile.  Aborted.' > $errorLog
	exit 1
fi

cat <<-'EOF' > $VAGRANT_DIR/$deployScript
#!/bin/bash

typeset confFileBasename=$1
typeset httpDaemon

typeset vetConf='weblogic-vet.conf'
typeset mockConf='weblogic-vet-mock.conf'

if [[ "$confFileBasename" = $vetConf || "$confFileBasename" = $mockConf ]]; then
	httpDaemon=httpd
elif [[ "$confFileBasename" = 'weblogic-staff.conf' ]]; then
	httpDaemon=httpd2
else
	echo 'Unknown staff or vet deploy.  Aborted.'
	exit
fi

if [[ "$confFileBasename" = $vetConf ]]; then
    rm -f /etc/$httpDaemon/conf.d/$mockConf
elif [[ "$confFileBasename" = $mockConf ]]; then
    rm -f /etc/$httpDaemon/conf.d/$vetConf
fi

rm -f /etc/$httpDaemon/conf.d/weblogic.conf
cp /vagrant/deployments/$confFileBasename /etc/$httpDaemon/conf.d
service $httpDaemon restart
EOF

chmod +x $VAGRANT_DIR/$deployScript
mkdir -p $deploymentsDir
cp $confFile $deploymentsDir

cd $VAGRANT_DIR
if [[ -f $envScript ]]; then
	. $envScript
fi
vagrant ssh vamf_apache --command "sudo /vagrant/$deployScript $confFileBasename > $deployLog 2>&1"
