#!/bin/bash

typeset webApp=$1
typeset warFile=$2
typeset warFileBasename=`basename $warFile`

typeset base=deployWarToApache
typeset baseShellScript=${base}.sh
typeset deployLog=${base}.log
typeset errorLog=${base}.error
typeset deploymentsDir=$VAGRANT_DIR/deployments
typeset deployScript=${deploymentsDir}/${baseShellScript}

typeset envScript='../set.env.sh'

rm $errorLog
mkdir -p $deploymentsDir

if [ -z $VAGRANT_DIR ] || [ ! -r $VAGRANT_DIR/Vagrantfile] ; then
	echo '$VAGRANT_DIR must be defined and contain a valid Vagrantfile.  Aborted.' > $errorLog
	exit 1
fi

cat <<-'EOF' > ${deployScript}
#!/bin/bash

typeset webApp=$1
typeset warFileBasename=$2
typeset varHtmlDir=/var/www2/html

cd $varHtmlDir
if [ ! -z $webApp ] && [ -d $varHtmlDir/$webApp ]; then
    echo Deleting $varHtmlDir/$webApp...
    rm -rf $webApp
fi

mkdir $webApp
cd $webApp

jar xvf /vagrant/deployments/${warFileBasename}
EOF

chmod +x $deployScript
cp $warFile $deploymentsDir

cd $VAGRANT_DIR
if [[ -f $envScript ]]; then
	. $envScript
fi
vagrant ssh vamf_apache --command "sudo /vagrant/deployments/$baseShellScript $webApp $warFileBasename > $deployLog 2>&1"
