define(['angular', 'app'], function (angular, app) {
	'use strict';

	app.directive('validationSummary', function($q, $timeout, focusService) {
		return {
			restrict: 'A',
			transclude: true,
			link: function(scope, elem, attr, ctrl, transclude) {
				elem.append(transclude());

				var formController = elem.controller('form');
				var $formElement = elem;

				// get label text for modelController without * required asterisk
				var getLabelTextFor = function(modelController) {
                    var $label = $formElement.find('label[for="' + $formElement.find('[name="' + modelController.$name + '"]').attr('id') + '"]');

					return $label.contents().filter(function(){ 
						return this.nodeType === 3; 
					})[0].nodeValue;
				};

				formController.validationSummary = {};
				formController.validationSummary.validate = function(errorGroup) {
					//make sure a digest loop has run to update form validation
					var defer = $q.defer();
					$timeout(function(){
						scope.errors = [];

						var requiredModelControllers = formController.$error.required;

						if (!_.isUndefined(requiredModelControllers)) {

							requiredModelControllers.forEach(function(modelController) {
								scope.errors.push(getLabelTextFor(modelController) + 'field is required');
							});
						}

						if(scope.errors.length !== 0){
							focusService.focusElement('.validation-summary h5');
							defer.reject();
						} else {
							defer.resolve();
						}
					});

					return defer.promise;
				};

				formController.validationSummary.summarizeAsync = function(promises) {
					scope.errors = [];

					$q.all(promises).then(
						function() {},
						function(promise) {
							var errors = promise.data;
							function appendErrorsToSummary(requestErrors){
								requestErrors.errors.forEach(function(error) {
									if (angular.isDefined(error.errorMessage)) {
										scope.errors.push(error.errorMessage);
									}
								});
							};
							if (errors && typeof errors !== "string") {
								if(Array.isArray(errors)) {
									errors.forEach(function(requestErrors){
										appendErrorsToSummary(requestErrors);
									});
								} else if(errors["objectType"] === "ValidationErrors" || errors["objectType"] === "LocalValidationErrors"){
									appendErrorsToSummary(errors);
								} else {
									for(var key in errors) {
										if(errors.hasOwnProperty(key)) {
											appendErrorsToSummary(errors[key]);
										}
									}
								}

								focusService.focusElement('.validation-summary h5');
							}
						});

				};

				formController.validationSummary.clear = function() {
					scope.errors = [];
				};


			},
			templateUrl: 'src/ui-components/form/validation/validation-summary/validation-summary_template.html'
		};
	});
});