define(['app', 'angular'], function (app, angular) {

	app.directive('inputText', function ($timeout) {
		return {
			restrict: 'E',
			require: 'ngModel',
			scope: {
				'label': '@',
				'name': '@',
				'ngModel': '=',
				'ngDisabled': '=',
				'ngRequired': '=',
				'ngReadonly': '=',
				'characterCounter': '=',
				'maxlength': '@',
				'rows': '@',
				'cols': '@',
				'showSecondaryLabel': '=?',
				'secondaryLabel': '@?',
				'placeholder' : '@',
                'dontCapitalize' : "=",
                'textAreaExtra': '@'
			},
			link: function (scope, element, attrs, ngModelCtrl) {
				var inputArea = element.find('textarea, input');

				var label = scope.label && scope.label.replace(/:/, '').trim();

				scope.errorHandling = {
					'required': {
						message: label + ' field is required.',
						priority: 1
					}
				};

			},
			controller: function ($scope) {
				var prevModel = $scope.ngModel;

				$scope.maxlength = $scope.maxlength || Infinity;

                $scope.noCap = $scope.dontCapitalize ? "off" : "on";

				$scope.charsLeft = function () {
					return $scope.maxlength - ($scope.ngModel ? $scope.ngModel.length : 0);
				};

				$scope.update = function () {
					if ($scope.ngModel && $scope.maxlength < $scope.ngModel.length) {
						$scope.ngModel = prevModel;
					}
					prevModel = $scope.ngModel;
				};
			},
			templateUrl: 'src/ui-components/form/controls/simple/input-text/input-text_template.html'
		};
	});

});