define(['jQuery', 'angular', 'angularUiBootstrap'], function ($, angular) {
	"use strict";

	var services = angular.module('accessibleTimePickerServices', ['ui.bootstrap'])
		.directive('scrollToTimeValue', function ($timeout) {
			return {
				restrict: 'A',
				link: function (scope, element, attrs) {
					function scrollMe(val) {
						element.find('[data-value="' + val + '"]').each(function () {
							var $li = $(this).closest('li'),
								$ul = $li.closest('ul'),
								$b = $ul.closest('b'),
								scrollTop = ($ul.children().index($li)) * ($li.height());
							$b.scrollTop(scrollTop);
							scope.$$phase || scope.$digest();
						});
					}

                    scope.$watch(attrs.scrollToTimeValue, function(){
                        $timeout(function() {
                            scrollMe(scope.$eval(attrs.scrollToTimeValue));
                        }, 0);
                    });

					var timeoutPromise;
					element.on('scroll', function (e) {
						$timeout.cancel(timeoutPromise);
						var currentTarget = e.currentTarget;
                        timeoutPromise = setTimeout(function () {
							var $ul = $(currentTarget).find("ul"),
								$lis = $ul.children(),
								lineHeight = $lis.eq(0).height(),
								top = $ul.position().top,
								n = Math.round(-top/lineHeight),
								$buttons = $ul.find('button'),
								$button = $lis.eq(n).find('button'),
								$prevSelected = $ul.find('.selected'),
								prevSelectedIndex = $buttons.index($prevSelected),
								typ = $ul.parent()[0].className;
							if (!$button.prop('disabled')) {
								$ul.scrollTop((-n * lineHeight) + lineHeight);
								scope.timeChosen[typ] = $button.attr('data-value');
							} else {
								$button = $ul.find('button:enabled').eq(prevSelectedIndex > n ? 0 : -1);
								scope.timeChosen[typ] = $button.attr('data-value');
								n = parseFloat(scope.timeChosen[typ]);
								$ul.scrollTop((-n * lineHeight) + lineHeight);
							}
							scope.$digest();
						}, 500);
					});
				}
			};
		})
        .directive('focusTime', function ($timeout) {
	        var timeoutPromise = null;
            return {
                restrict: 'A',
                link: function (scope, element, attrs) {
                    scope.$watch(attrs.focusTime, function(){
                        if (scope.$eval(attrs.focusTime)) {
                            $timeout(function () {
                                element.focus();
                            }, 0);
                        }
                    });
	                scope.onFocus = function(){
	                    $timeout.cancel(timeoutPromise);
	                    timeoutPromise = $timeout(function () {
	                        if(scope.timeChosen[attrs.type] !== parseInt(attrs.value)){
	                            scope.timeChosen[attrs.type] = parseInt(attrs.value);
	                        }
	                    }, 0);
	                };

                }
            };
        })
		.directive('accessibleTimePicker', function ($modal, $filter, $timeout) {
			return {
				restrict: 'A',
				require: 'ngModel',
				scope: {
					increment: '=?'
				},
				link: function (scope, element, attrs, ngModelCtrl) {
					element.bind('click', function (e) {
						e.preventDefault();
						var modalinstance = $modal.open({
							templateUrl: 'src/ui-components/form/controls/simple/accessibletimepicker/accessibletimepicker_template.html',
							controller:  'accessibleTimePickerController',
							windowClass: 'date-picker-modal',
							resolve: {
								currentvalue: function () {
									return ngModelCtrl.$modelValue;
								},
								increment : function() {
									return scope.increment || 1;
								}
							}
						});
						modalinstance.result.then(function (value) {
							ngModelCtrl.$setViewValue((value.hour < 10 ? "0" : "") + value.hour + ":"
                                + (value.minute < 10 ? "0" : "") + value.minute + " "
                                + (value.period - 1 ? "PM": "AM"));
							ngModelCtrl.$render();
                      		$timeout(function(){
                            	element.focus();
                        	}, 600);
                       	}, function (dismissreason) {
                        	$timeout(function(){
                        	    element.focus();
                        	}, 600);
                        });
					});
				}
			};
		})
		.controller('accessibleTimePickerController', function ($scope, $modalInstance, currentvalue, increment) {
			var currentDate = new Date();

			var parseTime = function (inputTimeString) {
				var dateObj = new Date("12/12/1212 " + inputTimeString);
				var miliHours = dateObj.getHours();
				return {
					hour:   miliHours % 12,
					minute: dateObj.getMinutes(),
					period: miliHours >= 12 ? 2 : 1
				};
			};

            var parseTimeString = function(inputTimeString){
                return /^\d{1,2}:\d{1,2} [ap]m$/i.test(inputTimeString);
            };

			$scope.periods = ["AM", "PM"];
			var currentMinutes = currentDate.getMinutes();
			currentMinutes = increment*Math.floor(currentMinutes/increment);
			$scope.NOW = parseTime(currentDate.getHours() + ":" + currentMinutes);
			$scope.focusOn = 'hour';
			$scope.increment = increment;

			$scope.forNumber = function (num) {
				return new Array(num);
			};

			$scope.timeChosen = parseTimeString(currentvalue) ? parseTime(currentvalue) : $scope.NOW;
            $scope.$watch('timeChosen', function(){
                $scope.timeChosen.hour   = parseInt($scope.timeChosen.hour);
                $scope.timeChosen.minute = parseInt($scope.timeChosen.minute);
                $scope.timeChosen.period = parseInt($scope.timeChosen.period);

                $scope.timeChosen.hour = ($scope.timeChosen.hour > 12) ? 1 :
                    ($scope.timeChosen.hour < 1) ? 12 : $scope.timeChosen.hour;
                $scope.timeChosen.minute = ($scope.timeChosen.minute > 59) ? 0 :
                    ($scope.timeChosen.minute < 0) ? 59 : $scope.timeChosen.minute;
                $scope.timeChosen.period = ($scope.timeChosen.period > 2) ? 1 :
                    ($scope.timeChosen.period < 1) ? 2 : $scope.timeChosen.period;
            }, true);

			$scope.timeclick = function (typ, value) {
				$scope.timeChosen[typ] = value;
                $scope.focusOn = $scope.nextFocus[$scope.focusOn];
			};

			$scope.close = function (e) {
				$modalInstance.dismiss('cancel');
				e.preventDefault();
				return false;
			}
			$scope.setkey = function (e) {
				e.preventDefault();
				switch (e.which) {
					case 13:
						$scope.set();
						break;
				}
				$scope.columnKeyDown(e);
			};
			$scope.set = function (e) {
				if (e) {
					e.preventDefault();
				}
				$modalInstance.close($scope.timeChosen);
				return false;
			};

			$scope.detectEscape = function (e) {
				if (e.which === 27) {
					$modalInstance.dismiss('cancel');
				}
			};

			$scope.formatHeading = function () {
				return "Selected time";
			};

            $scope.nextFocus = {hour:'minute', minute:'period', period:'set', set:'close', close:'hour'};
            $scope.prevFocus = {hour:'close', close:'set', set:'period', period:'minute', minute:'hour'};

			$scope.columnKeyDown = function (e) {
				var tab = function (direction) {
                        if(direction === 'next'){
                            $scope.focusOn = $scope.nextFocus[$scope.focusOn];
                        } else if (direction === 'prev') {
                            $scope.focusOn = $scope.prevFocus[$scope.focusOn];
                        }
					},
					ifPossible = function (dir) {
						if ($scope.focusOn === 'period') {
							$scope.timeChosen.period += dir;
						} else if ($scope.focusOn === 'hour') {
							$scope.timeChosen.hour += dir;
						} else if ($scope.focusOn === 'minute') {
							$scope.timeChosen.minute += dir;
						}
					};
				e.preventDefault(); //prevents scroll
				switch (e.which) {
					case 9:
						if (e.shiftKey) {
							tab('prev');
						} else {
							tab('next');
						}
						break;
					case 37:
						tab('prev');
						break;
					case 38:
						ifPossible(-1);
						break;
					case 39:
						tab('next');
						break;
					case 40:
						ifPossible(1);
						break;
				}
			};

			$scope.cancelKeyDown = function (e) {
				e.preventDefault();
				switch (e.which) {
					case 13:
						$modalInstance.dismiss('cancel');
						break;
				}

				$scope.columnKeyDown(e);
			};
		});
});
