define(['app', 'angular'], function (app, angular) {
	"use strict";

		app.directive('multiTime', function ($timeout, formatter, focusService) {
			return {
				restrict: 'AE',
				require: 'ngModel',
				scope: {
					label : "@",
					ngModel : "=",
					maxlength : "=",
					ngRequired : "=",
					ngDisabled : "="
				},
				link: function(scope, elem, attrs, ngModelCtrl) {

					scope.$watch('ngModel', function() {
						$timeout(function(){
							var timeArray = formatter.undotifyArrayOfPrimatives(scope.ngModel);
							var valid = true;
							elem.find("time-control").each(function(i, timeElem){
								if(angular.element(timeElem).controller("ngModel").$valid && timeArray.lastIndexOf(timeArray[i]) !== i) {
									valid = false;
									return false;
								}
							});
							ngModelCtrl.$setValidity('differentTimes', valid);
						});


					}, true);

					scope.errorHandling = {
						'differentTimes': {
							message: 'Duplicate reminder times are not permitted.',
							priority: 1
						}
					};

					scope.addTimeEntry = function() {
						scope.ngModel.push({"value" : ""});
						$timeout(function() {
							focusService.focusElement(elem.find("time-control:last input"));
						});
					};

					scope.deleteTimeEntry = function(n) {
						scope.ngModel.splice(n, 1);
						$timeout(function() {
							focusService.focusElement(elem.find("time-control:eq(" + (n === scope.ngModel.length ? n - 1 : n) + ") input"));
						});
					};


				},
				templateUrl: 'src/ui-components/form/controls/composite/input-multi-time-picker/multi-time_template.html'
			};
		});

});
