define(['MultiPhone'], function() {
	'use strict';

	describe("Multi-Phone directive", function (){
		var focusServiceMock,
			isolated,
			timeout,
			phone = { type: "Office", number: "(717) 818-9999" },
			emptyPhone = { type: "", number: "" },
			options = ['o1', 'o2'];

		beforeEach(function () {
			module('angularTemplateApp');

            focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);

			module(function($provide){
				$provide.value('focusService', focusServiceMock);
			});

			inject(function($compile, $rootScope, $templateCache, $timeout) {
			    var scope = $rootScope.$new(),
			        compiled,
			        element = angular.element("<multi-phone ng-model='phones' primary-label='primary' secondary-label='secondary' type-options='options'></multi-phone>");

                timeout = $timeout;

				scope.phones = [phone];
				scope.options = options;
				scope.primary = 'Primary';
				scope.secondary = 'Secondary';

				$templateCache.put('src/ui-components/form/controls/composite/input-multi-phone/multi-phone_template.html', '');

			    compiled = $compile(element)(scope);
			    scope.$digest();
			    isolated = compiled.isolateScope();
			});
		});

		describe("link variables", function () {
			it ("should be correct", function() {
			    expect(isolated.ngModel).toEqual([phone])
			    expect(isolated.primaryLabel).toBe('Primary');
			    expect(isolated.secondaryLabel).toBe('Secondary');
			    expect(isolated.typeOptions).toEqual(options);
			});
        });

		describe("link functions", function () {
			it ("should add a new phone object to the model and focus", function() {
			    isolated.addPhone();
			    timeout.flush()
			    expect(isolated.ngModel).toEqual([phone, emptyPhone]);
			    expect(focusServiceMock.focusElement).toHaveBeenCalled();
			});

			it ("should delete a phone object and focus", function() {
			    isolated.deletePhone(0);
			    timeout.flush()
			    expect(isolated.ngModel).toEqual([]);
			    expect(focusServiceMock.focusElement).toHaveBeenCalled();
			});
		});
	});
});