define(['app', 'angular'], function (app, angular) {
	"use strict";

    app.directive('multiPhone', function ($timeout, focusService) {
        return {
            restrict: 'AE',
            require: 'ngModel',
            scope: {
                primaryLabel : "=",
                secondaryLabel : "=",
                ngModel : "=",
                typeOptions : "="
            },
            link: function(scope, elem, attrs, ngModelCtrl) {
                scope.addPhone = function() {
                    if(scope.ngModel.length < 5) {
                        scope.ngModel.push({ number: "", type: "" });
                        $timeout(function() {
                            focusService.focusElement(elem.find("input-phone:last input"));
                        });
                    }
                };

                scope.deletePhone = function(index) {
                    scope.ngModel.splice(index, 1);
                    $timeout(function() {
                        focusService.focusElement(elem.find("input-phone:last input"));
                    });
                };
            },
            templateUrl: 'src/ui-components/form/controls/composite/input-multi-phone/multi-phone_template.html'
        };
    });
});
