define(['app', 'angular'], function (app, angular) {
	app.directive('backButton', function () {
		return {
			restrict: 'E',
			scope: {
				previousScreenLabel: '@'
			},
			link: function (scope, element, attrs) {
				scope.onlyVisibleOnPhone = attrs.class && attrs.class.indexOf('visible-xs') > -1;
			},
			controller: function ($scope, $state, $stateParams) {
				$scope.goBack = function(){
					var currentSectionParamValue = $stateParams.section;
					var paramSections = $state.current.data.paramSections;
					var backState;

					if(paramSections) {
						var numParamSections = paramSections.length;

						for(var i = 0; i < numParamSections; i++) {
							if(paramSections[i].paramValue === currentSectionParamValue) {
								backState = paramSections[i].backState;
							}
						}
					}

					backState = backState || $state.current.data.backState;

					$state.go(backState, $stateParams);
				};

				$scope.resolutionWidth = function(){
					return window.innerWidth < 768;
				};
			},
			templateUrl: 'src/ui-components/back-button/back-button_template.html'
		};
	});
});