define([
		'app',
		'resourcedirectory_service',
		'authentication_service',
		'mhpuser_service',
		'patient',
		'connection_error_service',
		'connection_timeout_service',
		'modalService',
		'SplashController',
		'HeaderController',
		'FooterController',
		'MainController',
		'HelpController',
		'AboutController',
		'accessibleDatePickerServices',
		'DateControls',
		'highcharts-ng',
		'SecondaryNavigationController',
		'HomeModule',
		'ManageSettingsModule',
		'UnauthorizedController'
	],
	function (app) {
		"use strict";

		app.config(function ($stateProvider, unsavedWarningsConfigProvider) {

			$stateProvider
				.state('main', {
					abstract: true,
					data: {
						moduleName: "VarUtility",
						requiresAuth: true
					},
					views: {
						"": {
							templateUrl: 'src/container/main/main_template.html',
							controller: 'MainController'
						},
						'header@main': {
							templateUrl: 'src/container/components/header/header_template.html',
							controller: 'HeaderController'
						},
						'footer@main': {
							templateUrl: 'src/container/components/footer/footer_template.html',
							controller: 'FooterController'
						}
					},
					resolve: {
						authcode: function ($q, $location, authenticationService) {
							var defer = $q.defer();
							var queryString = $location.absUrl().split("?")[1];
							var params = {};
							if(queryString) {
								params = authenticationService.checkForAuthCode(queryString);
							}
							if(params['code'] && params['state']) {
								authenticationService.getNewToken(params['code']).then(function(clientRedirectUri) {
									defer.reject({error: 'authcode', redirect: clientRedirectUri});
								});
							} else {
								defer.resolve();
							}

							return defer.promise;
						}
					}
				})
				.state('main.auth', {
					abstract: true,
					resolve: {
						// NOTE: for staff-side only, ensures mhpuser has been fetched in router instead of in localResourceDirectoryService
						auth: function ($q, pageService, authenticationService, mhpuser) {
							var defer = $q.defer();
							authenticationService.checkAuthStatus().then(function(isAuthenticated) {
								if(isAuthenticated) {
									// NOTE: 403 on checkAuthorizedKey will get caught by httpInterceptor,
									// navigating to state main.unauthorized
									$q.all({isAuthorized: authenticationService.checkAuthorizedKey(), user: mhpuser.fetch()}).then(
										function(responses) {
											defer.resolve();
										}
									);
								} else {
									defer.reject({error: 'auth'});
								}
							});
							return defer.promise;
						}
					}
				})
				.state('main.auth.two-panel', {
					abstract: true,
					views: {
						'@main': {
							templateUrl: 'src/container/components/content/two-column_template.html',
							controller: 'TwoPanelController'
						}
					}
				})
				.state('main.auth.two-panel.secondary-navigation', {
					abstract: true,
					views : {
						'secondary@main.auth.two-panel' : {
							templateUrl: "src/container/components/content/secondary-navigation/secondary-navigation_template.html",
							controller: "SecondaryNavigationController"
						}
					}
				})
				.state('main.splash', {
					url: '/login',
					data : {
						requiresAuth: false
					},
					templateUrl: 'src/container/splash/splash_template.html',
					controller: 'SplashController',
					module: 'preventNavigation'
				})
				.state('nonStateRedirect', {
					url: '/redirecting'
				})
				.state('main.unauthorized', {
					url: '/unauthorized',
					data: {
						moduleName: 'Unauthorized'
					},
					templateUrl: 'src/modules/home/unauthorized/unauthorized_template.html',
					controller: 'UnauthorizedController',
					resolve: {
						// NOTE: for Var Utility only, ensures mhpuser has been fetched in router instead of in localResourceDirectoryService
						auth: function ($q, pageService, authenticationService, mhpuser) {
							var defer = $q.defer();
							authenticationService.checkAuthStatus().then(function(isAuthenticated) {
								if(isAuthenticated) {
									mhpuser.fetch().then(
										function(response) {
											defer.resolve();
										}
									);
								} else {
									defer.reject({error: 'auth'});
								}
							});
							return defer.promise;
						}
					}
				});

			unsavedWarningsConfigProvider.useTranslateService = false;
		});

		app.run(function ($rootScope, $state, $window, resourceDirectory, pageService, connectionErrorService) {
			connectionErrorService.run();
			resourceDirectory.fetch();

			$rootScope.$on('$stateChangeError', function (event, toState, toParams, fromState, fromParams, error) {
				if (error.redirect) {
					$state.go('nonStateRedirect');
					$window.open(error.redirect, '_self', null, true);
				} else {
					switch (error.error) {
						case 'auth':
							$state.go('main.splash');
							break;
					}
				}
			});

			$rootScope.$on('$locationChangeStart', function(event, next, current) {
				if(current.match(/unauthorized/) && ! next.match(/unauthorized/)) {
					event.preventDefault();
				}
			});

		  	$rootScope.$on('$stateChangeSuccess', function(event, toState, toParams, fromState, fromParams) {
		    	if(toState.containerClass) {
		    		$rootScope.containerClass = toState.containerClass;
		    	};
		    });
		});
	});