define(['angular', 'angularMocks', 'RequestsController', 'angularUiBootstrap', 'lodash'], function(angular, mocks) {
	'use strict';

	describe("The Request controller", function () {
		var controller, 
			scope,
			state,
			q,
			modalServiceMock,
			focusServiceMock,
			connectionErrorServiceMock,
			formatterMock,
			requestsServiceMock,
			validationSummaryMock;

		beforeEach( function () {
			module('angularTemplateApp');

			modalServiceMock = jasmine.createSpyObj('modalService', ['showModal']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain', 'focusPrimary']);
			connectionErrorServiceMock = jasmine.createSpyObj('connectionErrorService', ['showServerErrorMsg']);
			formatterMock = jasmine.createSpyObj('formatter', ['toDashCase']);
			requestsServiceMock = jasmine.createSpyObj('RequestsService', ['fetch', 'save']);
			validationSummaryMock = jasmine.createSpyObj('validationSummary', ['validate', 'clear', 'summarizeAsync'])

			module(function($provide){
				$provide.value('modalService', modalServiceMock);
				$provide.value('focusService', focusServiceMock);
				$provide.value('connectionErrorService', connectionErrorServiceMock);
				$provide.value('formatter', formatterMock);
				$provide.value('RequestsService', requestsServiceMock);
			});

			inject(function($controller, $rootScope, $q, formatter) {
				scope = $rootScope.$new();

				modalServiceMock.showModal.andCallFake( function() {
					return {
						then: function(callback) { return callback(); }
					};
				} );

				requestsServiceMock.fetch.andCallFake( function() {
					var promise = $q.defer();
					var response = {
						status: 200,
						data: {
							id: '501',
							requestSettings:[{
								"typeOfCare": "AUDIOLOGY",
								"patientHistoryRequired": "",
								"patientHistoryDuration": 0,
								"submittedRequestLimit": 2
							}]
						}
					};
					promise.resolve({
						response: response
					});
					promise.then = function(callback) { return callback(response); };
					return promise;
				} );

				requestsServiceMock.save.andCallFake( function(data) {
					var promise = $q.defer();
					var response = {
						status: 200,
						data: data
					};
					promise.resolve({
						response: response
					});
					promise.then = function(callback) { return callback(response); };
					return promise;
				} );

				validationSummaryMock.validate.andCallFake( function(){
					return {
						then: function(callback) { return callback(); }
					};
				} );

				controller = $controller('RequestsController', {$scope: scope});

				 scope.requestForm = {
					validationSummary: validationSummaryMock,
					$setPristine: function (){},
					$setSubmitted: function (){}
				};
			});
		});

		it('should reset the form to the data that was last saved', function(){
			expect(scope.request).toEqual({
				id: '501',
				requestSettings:[{
					"typeOfCare": "AUDIOLOGY",
					"patientHistoryRequired": "",
					"patientHistoryDuration": 0,
					"submittedRequestLimit": 2
				}]
			});
			expect(scope.lastSavedRequest).toEqual(scope.request);

			scope.reset();
			expect(scope.lastSavedRequest.requestSettings[0]).toEqual({
				"typeOfCare": "AUDIOLOGY",
				"patientHistoryRequired": "",
				"patientHistoryDuration": 0,
				"submittedRequestLimit": 2
			});
			expect(scope.request).toEqual(scope.lastSavedRequest);
		});

		it('should save the form data', function(){
			scope.request = {
				id: '501',
				requestSettings: [{
					"typeOfCare": "AUDIOLOGY",
					"patientHistoryRequired": "No",
					"patientHistoryDuration": 2,
					"submittedRequestLimit": 3
				}]
			};
			scope.save();
			expect(requestsServiceMock.save).toHaveBeenCalledWith(scope.request);
			expect(modalServiceMock.showModal).toHaveBeenCalled();
			expect(validationSummaryMock.summarizeAsync).toHaveBeenCalled();

			expect(scope.request.requestSettings[0]).toEqual({
				'typeOfCare': 'AUDIOLOGY',
				'patientHistoryRequired': 'No',
				'patientHistoryDuration': 2,
				"submittedRequestLimit": 3
			});

			expect(scope.lastSavedRequest).toEqual(scope.request);
		});
	});
});
