define(['angular', 'app', 'RequestsService', 'moment' ], function (angular, app) {
	'use strict';
	app.controller('RequestsController', function ($scope, $http, $q,
		RequestsService, focusService, connectionErrorService, modalService, formatter) {
		focusService.focusMain();
		$scope.formatter = formatter;
		$scope.today = new Date();

		$scope.supportedMenu = [
			{value: "No", response: "Yes - Any Veteran"},
			{value: "Yes", response: "Yes - Based Upon Time Frame"}
		];

		$scope.lastSeenMenu = [
			{value: 730, days: "24 months (730 days)"},
			{value: 365, days: "12 months (365 days)"}
		];

		$scope.request = $scope.lastSavedRequest = {};

		RequestsService.fetch().then(function(response) {
			if(response.status !== 200) {
				return connectionErrorService.showServerErrorMsg(response);
			}

			// update request model
			$scope.request = response.data;
			// update form state
			$scope.lastSavedRequest = angular.copy($scope.request);

			$scope.maxSubmittedRequestMenu = (function() {
				var maxSubmittedRequestLimits = [];
				for (var i = 0; i < $scope.request.requestSettings.length; i++) {
					maxSubmittedRequestLimits.push($scope.request.requestSettings[i].enterpriseSubmittedRequestLimit);
				}
				var largest = Math.max.apply(null, maxSubmittedRequestLimits);
				return buildMaxSubmittedRequestMenu(largest);
			})();
		});

		var modalOptions = {
			actionButtonText: 'OK',
			headerText: 'Confirmation',
			bodyText: 'The Request settings have been saved.'
		};

		$scope.save = function(e){
			var formController = this.requestForm;
			formController.$setSubmitted();
			formController.validationSummary.validate().then(function() {

				var httpRequestPromise = RequestsService.save($scope.request).then(function(response){
					// update request model
					$scope.request = response.data;
					// update form state
					formController.$setPristine();
					formController.validationSummary.clear();
					$scope.lastSavedRequest = angular.copy($scope.request);

					// show confirmation modal
					modalService.showModal({}, modalOptions).then(function () {
						focusService.focusPrimary();
					});
				});

				formController.validationSummary.summarizeAsync([httpRequestPromise]);
			});
		};

		$scope.reset = function(){
			var formController = this.requestForm;
			formController.validationSummary.clear();
			formController.$setPristine();
			$scope.request = angular.copy($scope.lastSavedRequest);
		};
		
		function buildMaxSubmittedRequestMenu(number) {
			var limits = [];
			build(number);
			function build(number) {
				if (number > 0) {
					limits.push({value: number, max: number});
					return build(number - 1);
				} else {
					return number;
				}
			}
			return limits.reverse();
		};
	});
});
