define(['angular', 'app', 'moment'], function (angular, app) {
	'use strict';
	app.controller('ManageSettingsController', function ($scope, mhpuser, globalDelayTracker, focusService, previousState) {
		$scope.globalDelayTracker = globalDelayTracker;

		$scope.today = new Date();

		$scope.userFirstLastName = mhpuser.firstName + ' ' + mhpuser.lastName;
		$scope.facilityName = mhpuser.facilityName;


		// while the authorization page is under a module,
		// set focus after template has rendered
		var stopWatch = $scope.$watch('globalDelayTracker.active()', function(newValue, oldValue) {
			// if initial route on app start, set focus on app main title
			// else set focus on primary header
			if (newValue && previousState.isFirstAppRoute) {
				focusService.focusMain();
			} else {
				focusService.focusPrimary();
			}

			previousState.isFirstAppRoute = false;
			stopWatch();
		});
	});
});