define(['angular', 'angularMocks', 'DirectSchedulingController', 'angularUiBootstrap', 'lodash'], function(angular, mocks) {
	'use strict';

	describe('The Direct Scheduling controller', function () {
		var controller, 
			scope,
			state,
			q,
			modalServiceMock,
			focusServiceMock,
			connectionErrorServiceMock,
			formatterMock,
			directSchedulingServiceMock,
			validationSummaryMock;

		beforeEach( function () {
			module('angularTemplateApp');

			modalServiceMock = jasmine.createSpyObj('modalService', ['showModal']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain', 'focusPrimary']);
			connectionErrorServiceMock = jasmine.createSpyObj('connectionErrorService', ['showServerErrorMsg']);
			formatterMock = jasmine.createSpyObj('formatter', ['toDashCase']);
			directSchedulingServiceMock = jasmine.createSpyObj('DirectSchedulingService', ['fetch', 'save']);
			validationSummaryMock = jasmine.createSpyObj('validationSummary', ['validate', 'clear', 'summarizeAsync'])

			module(function($provide){
				$provide.value('modalService', modalServiceMock);
				$provide.value('focusService', focusServiceMock);
				$provide.value('connectionErrorService', connectionErrorServiceMock);
				$provide.value('formatter', formatterMock);
				$provide.value('DirectSchedulingService', directSchedulingServiceMock);
			});

			inject(function($controller, $rootScope, $q, formatter) {
				scope = $rootScope.$new();

				modalServiceMock.showModal.andCallFake( function() {
					return {
						then: function(callback) { return callback(); }
					};
				} );

				directSchedulingServiceMock.fetch.andCallFake( function() {
					var promise = $q.defer();
					var response = {
						status: 200,
						data: {
							id: '501',
							coreSettings:[{
								"typeOfCare": "AUDIOLOGY",
								"patientHistoryRequired": "",
								"patientHistoryDuration": 0
							}]
						}
					};
					promise.resolve({
						response: response
					});
					promise.then = function(callback) { return callback(response); };
					return promise;
				} );

				directSchedulingServiceMock.save.andCallFake( function(data) {
					var promise = $q.defer();
					var response = {
						status: 200,
						data: data
					};
					promise.resolve({
						response: response
					});
					promise.then = function(callback) { return callback(response); };
					return promise;
				} );

				validationSummaryMock.validate.andCallFake( function(){
					return {
						then: function(callback) { return callback(); }
					};
				} );

				controller = $controller('DirectSchedulingController', {$scope: scope});

				 scope.directSchedulingForm = {
					validationSummary: validationSummaryMock,
					$setPristine: function (){},
					$setSubmitted: function (){}
				};
			});
		});

		it('should reset the form to the data that was last saved', function(){
			expect(scope.directBooking).toEqual({
				id: '501',
				coreSettings:[{
					"typeOfCare": "AUDIOLOGY",
					"patientHistoryRequired": "",
					"patientHistoryDuration": 0
				}]
			});
			expect(scope.lastSavedDirectBooking).toEqual(scope.directBooking);

			scope.reset();
			expect(scope.lastSavedDirectBooking.coreSettings[0]).toEqual({
				"typeOfCare": "AUDIOLOGY",
				"patientHistoryRequired": "",
				"patientHistoryDuration": 0
			});
			expect(scope.directBooking).toEqual(scope.lastSavedDirectBooking);
		});

		it('should save the form data', function(){
			scope.directBooking = {
				id: '501',
				coreSettings: [{
					"typeOfCare": "AUDIOLOGY",
					"patientHistoryRequired": "No",
					"patientHistoryDuration": 2
				}]
			};
			scope.save();
			expect(directSchedulingServiceMock.save).toHaveBeenCalledWith(scope.directBooking);
			expect(modalServiceMock.showModal).toHaveBeenCalled();
			expect(validationSummaryMock.summarizeAsync).toHaveBeenCalled();

			expect(scope.directBooking.coreSettings[0]).toEqual({
				'typeOfCare': 'AUDIOLOGY',
				'patientHistoryRequired': 'No',
				'patientHistoryDuration': 2
			});

			expect(scope.lastSavedDirectBooking).toEqual(scope.directBooking);
		});
	});
});