define(['angular', 'app', 'DirectSchedulingService', 'moment' ], function (angular, app) {
	'use strict';
	app.controller('DirectSchedulingController', function ($scope, $http, $q,
		DirectSchedulingService, focusService, connectionErrorService, modalService, formatter) {
		focusService.focusMain();
		$scope.formatter = formatter;
		$scope.today = new Date();

		$scope.supportedMenu = [
			{value: "No", response: "Yes - Any Veteran"},
			{value: "Yes", response: "Yes - Based Upon Time Frame"}
		];

		$scope.lastSeenMenu = [
			{value: 730, days: "24 months (730 days)"},
			{value: 365, days: "12 months (365 days)"}
		];

		$scope.directBooking = $scope.lastSavedDirectBooking = {};

		DirectSchedulingService.fetch().then(function(response) {
			if(response.status !== 200) {
				return connectionErrorService.showServerErrorMsg(response);
			}

			// update direct booking model
			$scope.directBooking = response.data;
			// update form state
			$scope.lastSavedDirectBooking = angular.copy($scope.directBooking);
		});

		var modalOptions = {
			actionButtonText: 'OK',
			headerText: 'Confirmation',
			bodyText: 'The Direct Scheduling settings have been saved.'
		};

		$scope.save = function(e){
			var formController = this.directSchedulingForm;
			formController.$setSubmitted();
			formController.validationSummary.validate().then(function() {

				var httpRequestPromise = DirectSchedulingService.save($scope.directBooking).then(function(response){
					// update direct booking model
					$scope.directBooking = response.data;
					// update form state
					formController.$setPristine();
					formController.validationSummary.clear();
					$scope.lastSavedDirectBooking = angular.copy($scope.directBooking);

					// show confirmation modal
					modalService.showModal({}, modalOptions).then(function () {
						focusService.focusPrimary();
					});
				});

				formController.validationSummary.summarizeAsync([httpRequestPromise]);
			});
		};

		$scope.reset = function(){
			var formController = this.directSchedulingForm;
			formController.validationSummary.clear();
			formController.$setPristine();
			$scope.directBooking = angular.copy($scope.lastSavedDirectBooking);
		};
	});
});
