define([
		'app',
		'ManageSettingsController',
		'FormattedEmptyStringToNullValue',
		'RequiredNonZeroValue',
		'DirectSchedulingController',
		'RequestsController',
		'FilterSubmittedRequestLimit',
		'RequestsController',
		'FormatStopCodes'
	],
	function (app) {
		"use strict";

		app.config(function ($stateProvider, $urlRouterProvider) {
			$urlRouterProvider.otherwise(function ($injector) {
				var $state = $injector.get('$state');
				$state.go('main.auth.two-panel.secondary-navigation.manage-settings');
			});

			$stateProvider
				.state('main.auth.two-panel.secondary-navigation.manage-settings', {
					url: '/manage-settings',
					appNavIndex: 2,
					data: {
						moduleName: "Manage Settings",
						panel: "secondary",
						baseStateName : 'main.auth.two-panel.secondary-navigation.manage-settings',
						paramSections : [
							{
								paramValue : "direct-scheduling",
								sectionState: 'direct-scheduling',
								sectionName : "Direct Scheduling",
								sectionIndex : 1
							},
							{
								paramValue : "requests",
								sectionState: 'requests',
								sectionName : "Requests",
								sectionIndex : 2
							}
						]
					},
					views : {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/manage-settings/pages/manage-settings-placeholder_template.html',
							controller: 'ManageSettingsController'
						}
					},
					resolve : {
						previousState: function ($state) {
							var currentStateData = {
								isFirstAppRoute: $state.current.name === ""
							};
							return currentStateData;
						}
					}
				})
				.state('main.auth.two-panel.secondary-navigation.manage-settings.direct-scheduling', {
					url: '/{section:direct-scheduling}',
					data: {
						panel : "primary",
						backState : "^"
					},
					views : {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/manage-settings/pages/direct-scheduling/direct-scheduling_template.html',
							controller: 'DirectSchedulingController'
						}
					}
				})
				.state('main.auth.two-panel.secondary-navigation.manage-settings.requests', {
					url: '/{section:requests}',
					data: {
						panel : "primary",
						backState : "^"
					},
					views : {
						'primary@main.auth.two-panel': {
							templateUrl: 'src/modules/manage-settings/pages/requests/requests_template.html',
							controller: 'RequestsController'
						}

					}
				});
		});
	}
);
