define(['angular', 'app'], function (angular, app) {
  'use strict';

  app.directive('formattedEmptyStringToNullValue', function() {
    return {
      restrict: 'A',
      require: 'ngModel',
      link: function(scope, elem, attr, ngModel) {
        ngModel.$parsers.push(function(value){
          var modelValue = value;
          if (value === null || value === '' ) {
            modelValue = '';
          }
          return modelValue;
        });

        ngModel.$formatters.push(function(value){
          var viewValue = (value === '') ? null : value;

          return viewValue;
        });
      }
    };
  });
});