define(['angular', 'app'], function (angular, app) {
	'use strict';
	app.service('RequestsService', function ($http, $q, localResourceDirectoryService, mhpuser) {

		var RequestsService = {};

		var requestUrl = localResourceDirectoryService['request-eligibility-criteria'];
		var saveOptions = {};

		RequestsService.fetch = function() {
			return $http.get(requestUrl.replace('{site-code}', mhpuser.vistaLocation));
		};

		RequestsService.save = function(data) {
			// update parameters for saving
			if(!_.isEmpty(data.link)) {
				saveOptions = {
					url: data.link[0].href,
					method: 'put'
				};
			} else {
				saveOptions = {
					url: requestUrl.replace('{site-code}', mhpuser.vistaLocation),
					method: 'post'
				};
			}

			return $http[saveOptions.method](saveOptions.url, data);
		};

		return RequestsService;
	});
});