define(['RequestsService'], function () {
	'use strict';

	describe('The Rquests Service', function () {
		var $scope,
			$http,
			$httpBackend,
			$q,
			service,
			mhpuser,
			localResourceDirectory;

		beforeEach(function() {
			module('angularTemplateApp');

			localResourceDirectory = {
				'mhpuser': '/user',
				'request-eligibility-criteria' : '/request'
			};

			mhpuser = {
				vistaLocation: '501'
			};

			module(function($provide) {
				$provide.value('mhpuser', mhpuser);
				$provide.value('localResourceDirectoryService', localResourceDirectory);
			});

			inject(function($rootScope, _$httpBackend_, RequestsService) {
				$scope = $rootScope;
				$httpBackend = _$httpBackend_;
				service = RequestsService;
			});
		});


		it('should be able to fetch requests settings', function () {
			$httpBackend.expectGET(localResourceDirectory['request-eligibility-criteria']).respond('200',
				{
					id: '501',
					coreSettings:[{
						"typeOfCare": "OPTOMETRY",
						"patientHistoryRequired": "",
						"patientHistoryDuration": 0
					}]
				}
			);

			service.fetch();
			$scope.$digest();
			$httpBackend.flush();
		});

			// determines post or put based on presence of link property
		it('should be able to save new requests settings', function () {
			var postSettings = {
				id: '501',
				coreSettings:[{
					"typeOfCare": "OPTOMETRY",
					"patientHistoryRequired": "Yes",
					"patientHistoryDuration": 365
				}]
			}
			var savedSettings = angular.extend( {}, postSettings, {
				link: [{
					href: '/request/id/501'
				}]
			} );

			$httpBackend.expectPOST(localResourceDirectory['request-eligibility-criteria']).respond(function (method, url, data) {
				return [
					200,
					savedSettings,
					''
				];
			});

			service.save(postSettings);
			$scope.$digest();
			$httpBackend.flush();
		});

		it('should be able to save updated requests settings', function () {
			var savedSettings = {
				id: '501',
				coreSettings:[{
					"typeOfCare": "OPTOMETRY",
					"patientHistoryRequired": "Yes",
					"patientHistoryDuration": 720
				}],
				link: [{
					href: '/request/id/501'
				}]
			};

			$httpBackend.expectPUT(savedSettings.link[0].href).respond(function (method, url, data) {
				return [
					200,
					savedSettings,
					''
				];
			});

			service.save(savedSettings);
			$scope.$digest();
			$httpBackend.flush();
		});
	});
});