define(['DirectSchedulingService'], function () {
	'use strict';

	describe('The Direct Scheduling Service', function () {
		var $scope,
			$http,
			$httpBackend,
			$q,
			service,
			mhpuser,
			localResourceDirectory;

		beforeEach(function() {
			module('angularTemplateApp');

			localResourceDirectory = {
				'mhpuser': '/user',
				'direct-booking-eligibility-criteria' : '/direct-booking'
			};

			mhpuser = {
				vistaLocation: '501'
			};

			module(function($provide) {
				$provide.value('mhpuser', mhpuser);
				$provide.value('localResourceDirectoryService', localResourceDirectory);
			});

			inject(function($rootScope, _$httpBackend_, DirectSchedulingService) {
				$scope = $rootScope;
				$httpBackend = _$httpBackend_;
				service = DirectSchedulingService;
			});
		});


		it('should be able to fetch direct scheduling settings', function () {
			$httpBackend.expectGET(localResourceDirectory['direct-booking-eligibility-criteria']).respond('200',
				{
					id: '501',
					coreSettings:[{
						"typeOfCare": "OPTOMETRY",
						"patientHistoryRequired": "",
						"patientHistoryDuration": 0
					}]
				}
			);

			service.fetch();
			$scope.$digest();
			$httpBackend.flush();
		});

			// determines post or put based on presence of link property
		it('should be able to save new direct scheduling settings', function () {
			var postSettings = {
				id: '501',
				coreSettings:[{
					"typeOfCare": "OPTOMETRY",
					"patientHistoryRequired": "Yes",
					"patientHistoryDuration": 365
				}]
			}
			var savedSettings = angular.extend( {}, postSettings, {
				link: [{
					href: '/direct-booking/id/501'
				}]
			} );

			$httpBackend.expectPOST(localResourceDirectory['direct-booking-eligibility-criteria']).respond(function (method, url, data) {
				return [
					200,
					savedSettings,
					''
				];
			});

			service.save(postSettings);
			$scope.$digest();
			$httpBackend.flush();
		});

		it('should be able to save updated direct scheduling settings', function () {
			var savedSettings = {
				id: '501',
				coreSettings:[{
					"typeOfCare": "OPTOMETRY",
					"patientHistoryRequired": "Yes",
					"patientHistoryDuration": 720
				}],
				link: [{
					href: '/direct-booking/id/501'
				}]
			};

			$httpBackend.expectPUT(savedSettings.link[0].href).respond(function (method, url, data) {
				return [
					200,
					savedSettings,
					''
				];
			});

			service.save(savedSettings);
			$scope.$digest();
			$httpBackend.flush();
		});
	});
});