define(['angular', 'app', 'appConfig'], function (angular, app) {
	"use strict";
	app.service("formatter",
		function ($rootScope, $filter, config) {

			var formatter = {};

			formatter.getFormattedFrontendDate = function(dateString){
				if(!dateString) {
					return "";
				}

				var date = new Date(dateString);
				if(date.toString() === "Invalid Date") {
					return null;
				}
				return $filter('date')(date, config.formats.FRONTEND.DATE);
			};

			formatter.getFormattedFrontendTime = function(timeString){
				if(!timeString) {
					return "";
				}

				var date = new Date(timeString);
				if(date.toString() === "Invalid Date") {
					date = new Date("12/12/1212 " + timeString);
				}

				return $filter('date')(date, config.formats.FRONTEND.TIME);
			};

			formatter.getFormattedFrontendDateTime = function(dateTimeString){
				if(!dateTimeString) {
					return "";
				}

				var dateTime = new Date(dateTimeString);
				if(dateTime.toString() === "Invalid Date") {
					return null;
				}
				return $filter('date')(dateTime, config.formats.FRONTEND.DATE_TIME);
			};

			formatter.getFormattedBackendDate = function(dateString){
				if(!dateString) {
					return "";
				}

				var date = new Date(dateString);
				if(date.toString() === "Invalid Date") {
					return null;
				}
				return $filter('date')(date, config.formats.BACKEND.DATE);
			};

			formatter.getFormattedBackendTime = function(timeString){
				if(!timeString) {
					return "";
				}

				var date = new Date(timeString);
				if(date.toString() === "Invalid Date") {
					date = new Date("12/12/1212 " + timeString);
				}

				return $filter('date')(date, config.formats.BACKEND.TIME);
			};

			formatter.getFormattedBackendDateTime = function(dateTimeString){
				if(!dateTimeString) {
					return "";
				}
				
				var dateTime = new Date(dateTimeString);
				if(dateTime.toString() === "Invalid Date") {
					return null;
				}
				return $filter('date')(dateTime, config.formats.BACKEND.DATE_TIME);
			};

			formatter.getDateTimeMinusDelta = function(date, delta, format){
				date = new Date(date);
				var months = delta.months || 0;
				var days = delta.days || 0;
				var years = delta.years || 0;
				var hours = delta.hours || 0;
				var minutes = delta.minutes || 0;
				var seconds = delta.seconds || 0;
				var milliseconds = delta.milliseconds || 0;
				date = new Date(date.getFullYear()+years, date.getMonth()+months, date.getDate()+days,
					date.getHours()+hours, date.getMinutes()+minutes, date.getSeconds()+seconds, date.getMilliseconds()+milliseconds);
				
				if(format ==="front") {
					return formatter.getFormattedFrontendDateTime(date);
				} else {
					return formatter.getFormattedBackendDateTime(date)
				}
			};

			formatter.getDateRangeFromStartDate = function(startDate, delta){
				var endDate = formatter.getDateTimeMinusDelta(startDate, delta, "front");
				return {
					startDate : formatter.getFormattedFrontendDate(startDate),
					endDate : formatter.getFormattedFrontendDate(endDate)
				};
			};

			formatter.getDateRangeFromEndDate = function(endDate, delta){
				delta = angular.copy(delta);
				for(var key in delta) {
					if(delta.hasOwnProperty(key)) {
						delta[key] = -1 * delta[key];
					}
				}

				var startDate = formatter.getDateTimeMinusDelta(endDate, delta, "front");

				return {
					startDate : formatter.getFormattedFrontendDate(startDate),
					endDate : formatter.getFormattedFrontendDate(endDate)
				};
			};

			formatter.getDefaultDateRange = function(){
				var startDate = new Date();
				return formatter.getDateRangeFromEndDate(startDate, config.defaults.DATE_RANGE_DELTA);
			};

			formatter.dotifyArrayOfPrimatives = function(array){
				return array.map(function(item){
					return {value : item};
				});
			};

			formatter.undotifyArrayOfPrimatives = function(array){
				return array.map(function(item){
					return item.value;
				});
			};

			formatter.toDashCase = function (item) {
				return item.replace(/ /g, '-').toLowerCase();
			};

			return formatter;
		
		});
});