define(['angular', 'jQuery'], function (angular, $) {
	'use strict';

	angular.module('focusManager', [])
		.service('focusService',
		function ($rootScope, $timeout) {
			var focusService = {};

			var focusRace = $timeout(function(){});
			
			var requireDelay = /Safari/.test(navigator.userAgent);
			
			focusService.focusMain = function () {
				$rootScope.$emit('focusMain');
			};

			focusService.focusPrimary = function () {
				$rootScope.$emit('focusPrimary');
			};

			focusService.focusSecondary = function () {
				$rootScope.$emit('focusSecondary');
			};

			focusService.focusTopModal = function() {
				var watchListener = $rootScope.$watch(function () {
					return angular.element('.modal:last-of-type .modal-header h3').is(":visible");
				}, function (isVisible, wasVisible) {
					$timeout(function () {
						if (isVisible) {
			                focusService.focusElement('.modal:last-of-type .modal-header h3');
			                watchListener();
						}
					});
				});
			};

			focusService.focusElement = function (element, noDelay) {
				$timeout.cancel(focusRace);
				focusRace = $timeout(function () {
					element = typeof element === "string" ? document.querySelector(element) : element;
					element.blur();
					element.focus();
				}, !requireDelay || noDelay ? 0 : 600);
			};

			return focusService;
		}
	)

		.directive("mainFocus", function ($rootScope, $timeout, focusService) {
			return {
				restrict: "A",
				link: function (scope, element) {
					element.attr('tabindex', -1);
					$rootScope.$on('focusMain', function () {
						$timeout(function(){focusService.focusElement(element);});
					});
				}
			};
		})

		.directive("primaryFocus", function ($rootScope, $timeout, focusService) {
			return {
				restrict: "A",
				link: function (scope, element) {
					element.attr('tabindex', -1);
					$rootScope.$on('focusPrimary', function () {
						$timeout(function(){focusService.focusElement(element);});
					});
				}
			};
		})

		.directive("secondaryFocus", function ($rootScope, $timeout, focusService) {
			return {
				restrict: "A",
				link: function (scope, element) {
					element.attr('tabindex', -1);
					$rootScope.$on('focusSecondary', function () {
						$timeout(function(){focusService.focusElement(element);});
					});
				}
			};
		});
});