define(['angular', 'app', 'resourcedirectory_service'], function (angular, app) {
	"use strict";
	app.service('mhpuser', function ($http, $q, resourceDirectory, authenticationService) {

		var mhpUser = {},
			isReady;

		mhpUser.fetch = function () {

			if (isReady) {
				return isReady.promise;
			}

			isReady = $q.defer();

			$q.all([resourceDirectory.fetch(), authenticationService.checkAuthStatus()]).then(
				function (response) {
					if(response[1]) {
						$http.get(response[0]['mhpuser']).success(function (response) {
							var mhpuserLinks = new Object();
							response['link'].forEach(function (link) {
								mhpuserLinks[link['title']] = link['href'];
							});
							response['link'] = mhpuserLinks;
							angular.extend(mhpUser, response);
							isReady.resolve(response);
						}).error(function (error) {
							isReady.reject(error);
							isReady = null;
						});
					}
				},
				function (error) {
					isReady.reject(error);
					isReady = null;
				}
			);

			return isReady.promise;
		};

		return mhpUser;
	});
});