define(['angular', 'app'], function (angular, app) {
	"use strict";

	app.factory('httpInterceptor', function($q, $injector) {
		var interceptor = {};

		interceptor.responseError = function(rejection) {
			var newPromise;
			switch (rejection.status) {
				case 400:
					break;
				case 401:
				case 403:
					if(rejection.config.url.match(/rest\/v.*$/)) {
						$injector.invoke(['$state', function($state) {
							$state.go('main.unauthorized');
							return $q.defer().resolve();
						}]);
					} else {
						$injector.invoke(['authenticationService', 'connectionTimeoutService', function (authenticationService, connectionTimeoutService) {
							if (authenticationService.isAuthenticated()) {
								connectionTimeoutService.showSessionEndedMsg();
							}
						}]);
					}
					break;
				case 404:
					if(rejection.config.url.match(/rest\/v.*$/)) {
						return rejection;
					}
				default:
					if(rejection.status >= 100){
						newPromise = $injector.invoke(['connectionErrorService', function (connectionErrorService) {
							return connectionErrorService.showServerErrorMsg(rejection);
						}]);
					}
					break;
			}

			return newPromise || $q.reject(rejection);
		};

		return interceptor;
	});

});
