define(['angular', 'app'], function (angular, app) {
	'use strict';

	app.controller('SecondaryNavigationController', function ($scope, $q, $state, $filter, $injector, focusService) {

		$scope.dataPointers = {};
		var listItemTemplateUrl = "src/container/components/content/secondary-navigation/secondary-navigation-item_template.html";

		var baseState = null;

		$scope.$on('$stateChangeSuccess', function (event, toState, toParams, fromState, fromParams) {
			$scope.secondaryNavTitle = toState.data.moduleName;
			$scope.headerButton = $state.current.data.headerButton;

			var tokenizedStateName = toState.name.split(".");
			var baseStateName = tokenizedStateName.slice(0, tokenizedStateName.indexOf("secondary-navigation") + 2).join(".");
			var stateTester = new RegExp("^" + baseStateName + ".?[A-Za-z\-]*$");

			var stateList = $state.get();
			baseState = $state.get(baseStateName);

			var validStateList = [];

			function addListButtonClass(data){
				var uniqueClass = data.sectionName.replace(/\s/g, "-").replace(/\//ig, "-").toLowerCase();
				if(data.class) {
					if(data.class.indexOf(uniqueClass) === -1) {
						data.class = data.class + " " + uniqueClass;
					}
				} else {
					data.class = uniqueClass;
				}
			}

			stateList.forEach(function(state){
				if(stateTester.test(state.name)) {
					if(state.data.paramSections && state.data.baseStateName === state.name) {
						state.data.paramSections.forEach(function(data){
							data.stateName = data.stateName || state.name;
							data.initialState = data.initialState || state.data.initialState;
							data.templateUrl = data.templateUrl || listItemTemplateUrl;
							addListButtonClass(data);
						});
						validStateList = validStateList.concat(state.data.paramSections);
					} else if(state.data.sectionName) {
						addListButtonClass(state.data);
						state.data.stateName = state.name;
						state.data.templateUrl = state.data.templateUrl || listItemTemplateUrl;
						validStateList.push(state.data);
					}
				}
			});

			var filterPromise;
			
			if(baseState.data.filter) {
				filterPromise = $injector.invoke([baseState.data.filter, function (navFilter) {
					return navFilter.filter(validStateList);
				}]);
			} else {
				filterPromise = $q.when(validStateList);
			}

			filterPromise.then(function(validStateList){
				$scope.dataPointers.list = $filter("orderBy")(validStateList, "sectionIndex");
			});

		});

		$scope.headerButtonClick = function(){
			var tmpFn = function(headerButtonService) {
				headerButtonService.onClick().finally(function () {
					focusService.focusElement('button[ng-click="headerButtonClick()"]');
				});
			};
			tmpFn.$inject = [$state.current.data.headerButton.service];
			$injector.invoke(tmpFn);
		};

		$scope.isSelected = function(item) {
			var isSelected = $state.includes(item.stateName);
			return item.paramValue ? isSelected && item.paramValue === $state.params.section : isSelected;
		};

		$scope.getDetails = function(item) {
			if(item.name) {
				$state.go(item.name + (item.initialState ? ("." + item.initialState) : ""));
			} else if (item.sectionState) {
				$state.go(item.stateName + '.' + item.sectionState, {section: item.paramValue});
			} else {
				$state.go(item.stateName + (item.initialState ? ("." + item.initialState) : ''), {section: item.paramValue});
			}
		};

	});
});