require 'rubygems'
require 'rspec'
require 'watir-webdriver'

require_relative '../module/DriverUtility'
require_relative './rspec_helper'
require_relative '../pages/landing'
require_relative '../pages/login'
require_relative '../common/common'
require_relative '../pages/user_menu'
require_relative '../pages/launchpad'

describe '[Story VARUT-8: Utility - User Menu & Logout],
          [Story VARUT-9: Utility - About Page]
          [Story VARUT-294]: Utility -- Launchpad Feature
          [Story VARUT-353: Utility - Update version in footer and about]'  do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @landing = Landing.new(@driver)
    @launchpad = Launchpad.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @userMenu = UserMenuOption.new(@driver)
  end

  after(:all) do
    @driver.close
  end

  context 'AC#VARUT-132|TC#VARUT-137: Validate user Menu and Logout
           AC#VARUT-366|TC#VARUT-367: Update version in footer and criteria' do
    it "Login" do
      @common.loginEndsOnHome("ACCESS7", "VERIFY7!", "BOSTON HCS VAMC")

      Watir::Wait.until {@landing.footerUserInfo_element.present?}

      expect(@landing.appVersion).to eq("VAR Utility - v1.0.0")
      expect(@landing.footerUserInfo).to eq("Logged in as PROVIDER, SEVEN")
    end

    it "User Menu" do
      @userMenu.userMenu_element.when_visible(TIME_OUT_LIMIT)
      @userMenu.userMenu_element.click
      @userMenu.menuHeader_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.menuHeader.split("\n")[0]).to eq("User Menu")
    end



    context 'AC#VARUT-179|TC#VARUT-180: Validate About Page
             AC#VARUT-366|TC#VARUT-367: Update version in footer and criteria'
    it "About Page Validation" do
      expect(@userMenu.about_element.text).to eq("About")
      @userMenu.about
      @userMenu.aboutTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.aboutTitle_element.text).to eq("About")
      expect(@userMenu.content_element.text).to eq("VAR Utility - v1.0.0")
      expect(@userMenu.contentLine2_element.text).to eq("The VAR Utility allows users to set facility-level configurations for the VAR app.")
      expect(@userMenu.contentLine3_element.text).to eq('See the User Guide for more detailed instructions for using this app.')
    end

    context 'AC#VARUT-228|TC#VARUT-229: Validate User Guide Link'
    it "User Guide Validation" do
      @userMenu.aboutTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.aboutTitle_element.text).to eq("About")
      @userMenu.userGuideLink
      switchWindowToWindowHandleLast
      expect(getCurrentURL).to eq("https://IP      /var-utility/assets/pdfs/var-utility-guide.pdf")
      switchWindowToWindowHandleFirst
      @userMenu.aboutTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@userMenu.aboutTitle).to eq('About')

      @userMenu.ok_element.when_visible(TIME_OUT_LIMIT)
      @userMenu.ok
      @userMenu.about_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.about_element.text).to eq("About")

    end

    it "Launchpad -- Navigates the user to the VA Launchpad" do
      @userMenu.menuHeader_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.menuHeader.split("\n")[0]).to eq("User Menu")
      @userMenu.launchpad_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.launchpad_element.text).to eq("Launchpad")
      sleep 1
      @userMenu.launchpad
      @common.waitWhileSpinnerPresent

      @launchpad.launchpad_eula_accept_element.when_visible(TIME_OUT_LIMIT)
      @launchpad.launchpad_eula_accept

      @launchpad.launchpadTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@launchpad.launchpadTitle).to eq("Launchpad")
      expect(@launchpad.footer_name).to eq("Logged in as PROVIDER, SEVEN - BOSTON HCS VAMC")

    end

    it "Log out - returns user to Launchpad" do
      @driver.goto(BASE_URL)
      @common.waitWhileSpinnerPresent

      @userMenu.userMenu_element.when_visible(TIME_OUT_LIMIT)
      @userMenu.userMenu_element.click
      @userMenu.menuHeader_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.menuHeader.split("\n")[0]).to eq("User Menu")

      @userMenu.logOut_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.logOut_element.text).to eq("Logout")
      sleep(1)
      @userMenu.logOut
      @common.waitWhileSpinnerPresent
      sleep(3)

      Watir::Wait.until {@launchpad.launchpadTitle == "Launchpad"}
      expect(@launchpad.launchpadTitle).to eq("Launchpad")

      expect(@launchpad.footer_name).to eq("Not logged in")


    end



  end
end





