require 'rubygems'
require 'rspec'
require 'watir-webdriver'

require_relative '../module/DriverUtility'
require_relative './rspec_helper'
require_relative '../pages/landing'
require_relative '../pages/modal'
require_relative '../pages/base/base'
require_relative '../pages/login'
require_relative '../common/common'
require_relative '../pages/manage_settings'
require_relative '../module/DateUtility'
require_relative '../helper/table'
require_relative '../pages/error_validation'
require_relative '../pages/manage_settings/direct_scheduling'
require_relative '../pages/manage_settings/request_settings'
require_relative '../module/database/MongoUtility'

describe '[Story VARUT-82|Story VARUT-223 : Utility - Requests - View/Edit Service Settings ],
          [Story VARUT-217: Utility - Display Stop Codes]
          [Story VARUT-528: VAR Utility - Allow users to configure request limit]'  do
  include DriverUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @db = connectToMongoDB("var-utility")
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @base = Base.new(@driver)
    @request_setting = Request_Settings.new(@driver)
    @manage_setting = Manage_Settings.new(@driver)
    @table = Table.new(@driver)
    @error = Error_Validation.new(@driver)
    @modal = Modal.new(@driver)

  end

  after(:all) do
    @driver.close
  end

  #Reset Data in Mongo DB
  it "Remove Mongo" do
    removeCollection("requestEligibilityCriteria", @db)

    updateDocument("clinical-services", "323", "submittedRequestLimit", 1, @db)
    updateDocument("clinical-services", "203", "submittedRequestLimit", 2, @db)
    updateDocument("clinical-services", "408", "submittedRequestLimit", 2, @db)
    updateDocument("clinical-services", "502", "submittedRequestLimit", 2, @db)
  end

  context '[AC#VARUT-356|TC#VARUT-357:
           [AC#VARUT-358|TC#VARUT-359 - Validate requests settings],
           [AC#VARUT-707|TC#VARUT-708: Test - Validate display of Stop codes for each Type of Care]
           [AC#VARUT-187|TC#VARUT-186: Test - View/Edit Service Patient History Limit
           [AC#VARUT-1095|TC#VARUT-1096: Verify Allow users to configure request limit]' do
    it "Login" do
      @landing.login_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.login_element.visible?).to eq(true)
      @landing.login
      @login.login_element.when_visible(TIME_OUT_LIMIT)
      expect(@login.has_expected_title?).to eq(true)
      @login.login_with("ACCESS7", "VERIFY7!", "BOSTON HCS VAMC")

      @common.waitWhileSpinnerPresent()

      @landing.footerUserInfo_element.when_present(TIME_OUT_LIMIT)

      Watir::Wait.until {@landing.footerUserInfo == "Logged in as PROVIDER, SEVEN"}
      expect(@landing.footerUserInfo).to eq("Logged in as PROVIDER, SEVEN")
    end

      it "Direct Scheduling Page" do
        @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
        expect(@landing.primary_header).to eq("Home")
        expect(@landing.secondary_header).to eq("Manage Settings")

        @manage_setting.clickOption('Requests')
        expect(@landing.primary_header).to eq("Requests")

        Watir::Wait.until {@table.tableList_elements.length > 1}

        expect(@table.tableList_elements.length).to eq(4)

        expect(@table.getNthTableHeader(0)).to eq("Type of Care\n(Primary/Secondary Stop Code)")
        expect(@table.getNthTableHeader(1)).to eq("Supported at this Facility?")
        expect(@table.getNthTableHeader(2)).to eq("* Last seen within (Months)")
        expect(@table.getNthTableHeader(3)).to eq("* Submitted Request Limit")

        #Column1 data
        expect(@table.getTextForRowCol(1,1)).to eq("Primary Care\n(322, 323, 350)")
        expect(@table.getTextForRowCol(2,1)).to eq("Audiology\n(203)")
        expect(@table.getTextForRowCol(3,1)).to eq("Optometry\n(408)")
        expect(@table.getTextForRowCol(4,1)).to eq("Outpatient Mental Health\n(502/125, 502/185, 502/186, 502/187, 502/509, 502/510)")

        #Column2 data
        expect(@request_setting.primaryCare_options).to eq(["No", "Yes - Any Veteran"])
        expect(@request_setting.audiology_options).to eq(["No", "Yes - Any Veteran", "Yes - Based Upon Time Frame"])
        expect(@request_setting.optometry_options).to eq(["No", "Yes - Any Veteran", "Yes - Based Upon Time Frame"])
        expect(@request_setting.outpatientMentalHealth_options).to eq(["No", "Yes - Any Veteran", "Yes - Based Upon Time Frame"])

      end

      it "Validate Type of Care = Audiology" do
        #Type of Care = Audiology
        @request_setting.audiology = "No"
        expect(@request_setting.audiologyLastSeen_element.exists?).to eq(false)

        @request_setting.audiology = "Yes - Any Veteran"
        expect(@request_setting.audiologyLastSeen_element.exists?).to eq(false)

      end

      it "Validate Type of Care = Optometry" do
        #Type of Care = Optometry
        @request_setting.optometry = "No"
        expect(@request_setting.optometryLastSeen_element.exists?).to eq(false)

        @request_setting.optometry = "Yes - Any Veteran"
        expect(@request_setting.optometryLastSeen_element.exists?).to eq(false)

      end

      it "Validate Type of Care = Outpatient Mental Health" do
        #Type of Care = Outpatient Mental Health
        @request_setting.outpatientMentalHealth = "No"
        expect(@request_setting.outpatientMentalHealthLastSeen_element.exists?).to eq(false)

        @request_setting.outpatientMentalHealth = "Yes - Any Veteran"
        expect(@request_setting.outpatientMentalHealthLastSeen_element.exists?).to eq(false)

      end

      it "Submitted Request Limit" do

        #Default value
        expect(@request_setting.primaryCareRequestLimit_options).to eq(["1"])
        expect(@request_setting.primaryCareRequestLimit).to eq("1")

        expect(@request_setting.audiologyRequestLimit_options).to eq(["1", "2"])
        expect(@request_setting.audiologyRequestLimit).to eq("2")

        expect(@request_setting.optometryRequestLimit_options).to eq(["1", "2"])
        expect(@request_setting.optometryRequestLimit).to eq("2")

        expect(@request_setting.outpatientMentalHealthRequestLimit_options).to eq(["1", "2"])
        expect(@request_setting.outpatientMentalHealthRequestLimit).to eq("2")

        updateDocument("clinical-services", "323", "submittedRequestLimit", 5, @db)
        updateDocument("clinical-services", "203", "submittedRequestLimit", 5, @db)
        updateDocument("clinical-services", "408", "submittedRequestLimit", 4, @db)
        updateDocument("clinical-services", "502", "submittedRequestLimit", 1, @db)

        #Select Continue in the confirmation modal
        @base.home_btn

        @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)
        expect(@modal.modalTitle).to eq("Confirmation")

        @modal.continue

        @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)

        @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
        expect(@landing.primary_header).to eq("Home")
        expect(@landing.secondary_header_element.when_present(TIME_OUT_LIMIT))

        sleep (3)
        @manage_setting.clickOption('Requests')

        Watir::Wait.until {@table.tableList_elements.length > 1}

        expect(@request_setting.primaryCareRequestLimit_options).to eq(["1", "2", "3", "4", "5"])
        @request_setting.primaryCareRequestLimit = 4

        expect(@request_setting.audiologyRequestLimit_options).to eq(["1", "2", "3", "4", "5"])
        @request_setting.audiologyRequestLimit = 3

        expect(@request_setting.optometryRequestLimit_options).to eq(["1", "2", "3", "4"])
        @request_setting.optometryRequestLimit = 2

        expect(@request_setting.outpatientMentalHealthRequestLimit_options).to eq(["1"])
        @request_setting.outpatientMentalHealthRequestLimit = 1

      end


      it "Validate Confirmation Modal on Save" do
        #Primary Care
        @request_setting.optometry = "Yes - Any Veteran"

        #Audiology
        @request_setting.audiology = "Yes - Based Upon Time Frame"
        expect(@request_setting.audiologyLastSeen_element.exists?).to eq(true)
        expect(@request_setting.audiologyLastSeen_options).to eq(["Select", "24 months (730 days)", "12 months (365 days)"])

        #Select Duration and Save.
        @request_setting.audiologyLastSeen = "24 months (730 days)"

        #Optometry
        @request_setting.optometry = "Yes - Based Upon Time Frame"
        expect(@request_setting.optometryLastSeen_element.exists?).to eq(true)
        expect(@request_setting.optometryLastSeen_options).to eq(["Select", "24 months (730 days)", "12 months (365 days)"])

        #Select Duration and Save.
        @request_setting.optometryLastSeen = "12 months (365 days)"

        #Outpatient Mental Health
        @request_setting.outpatientMentalHealth = "Yes - Based Upon Time Frame"
        expect(@request_setting.outpatientMentalHealthLastSeen_element.exists?).to eq(true)
        expect(@request_setting.outpatientMentalHealthLastSeen_options).to eq(["Select", "24 months (730 days)", "12 months (365 days)"])

        #Select Duration and Save.
        @request_setting.outpatientMentalHealthLastSeen = "24 months (730 days)"

        @request_setting.bottomSave

        #Validate Confirmation Modal
        @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)

        expect(@modal.modalTitle).to eq("Confirmation")
        expect(@modal.content).to eq("The Request settings have been saved.")

        @modal.ok

        Watir::Wait.until {@table.tableList_elements.length > 1}

        #@requests_setting.audiology_element.when_visible(TIME_OUT_LIMIT)

        #Validate that the selections are saved.
        expect(@request_setting.audiology).to eq("Yes - Based Upon Time Frame")
        expect(@request_setting.audiologyLastSeen).to eq("24 months (730 days)")
        expect(@request_setting.optometry).to eq("Yes - Based Upon Time Frame")
        expect(@request_setting.optometryLastSeen).to eq("12 months (365 days)")
        expect(@request_setting.outpatientMentalHealth).to eq("Yes - Based Upon Time Frame")
        expect(@request_setting.outpatientMentalHealthLastSeen).to eq("24 months (730 days)")

        expect(@request_setting.primaryCareRequestLimit).to eq("4")
        expect(@request_setting.audiologyRequestLimit).to eq("3")
        expect(@request_setting.optometryRequestLimit).to eq("2")
        expect(@request_setting.outpatientMentalHealthRequestLimit).to eq("1")

      end

      it "Retrieve mongo" do
        #getDocumentByObjId(collectionName, objId, columnName, db)
        #value =  getDocumentByObjId("directBookingEligibilityCriteria", "523", "coreSettings", @db)

        value = getNthRequestSettings("requestEligibilityCriteria", "523", 0, @db)
        expect("").to eq(value['patientHistoryRequired'].to_s)
        expect(PRIMARY_CARE).to eq(value['typeOfCare'].to_s)

        value = getNthRequestSettings("requestEligibilityCriteria", "523", 1, @db)
        expect("Yes").to eq(value['patientHistoryRequired'].to_s)
        expect(AUDIOLOGY).to eq(value['typeOfCare'].to_s)
        expect("730").to eq(value['patientHistoryDuration'].to_s)

        value = getNthRequestSettings("requestEligibilityCriteria", "523", 2, @db)
        expect("Yes").to eq(value['patientHistoryRequired'].to_s)
        expect(OPTOMETRY).to eq(value['typeOfCare'].to_s)
        expect("365").to eq(value['patientHistoryDuration'].to_s)

        value = getNthRequestSettings("requestEligibilityCriteria", "523", 3, @db)
        expect("Yes").to eq(value['patientHistoryRequired'].to_s)
        expect(MENTAL_HEALTH).to eq(value['typeOfCare'].to_s)
        expect("730").to eq(value['patientHistoryDuration'].to_s)

      end

      it "Error validation" do
        #Last Seen in Months is a required field
        #Click Save without selecting a value for last seen for Audiology Optometry and Outpatient Mental health

        @request_setting.audiologyLastSeen = "Select"
        @request_setting.optometryLastSeen = "Select"
        @request_setting.outpatientMentalHealthLastSeen = "Select"
        @request_setting.topSave

        @error.errorSummaryHeader_element.when_visible(TIME_OUT_LIMIT)

        verifyErrorMessage("Last Seen Within (Months) " + AUDIOLOGY + " field is required")
        verifyErrorMessage("Last Seen Within (Months) " + OPTOMETRY + " field is required")
        verifyErrorMessage("Last Seen Within (Months) " + MENTAL_HEALTH + " field is required")

        #Click Cancel reverts back to the last saved state and error messages are not displayed
        @request_setting.topCancel

        Watir::Wait.until {@table.tableList_elements.length > 1}

        expect(@error.errorSummaryHeader_element.exists?).to eq(false)
        expect(@error.isErrorMsgDisplayed?("Last Seen Within (Months) " + AUDIOLOGY + " field is required")).to eq(false)
        expect(@error.isErrorMsgDisplayed?("Last Seen Within (Months) " + OPTOMETRY + " field is required")).to eq(false)
        expect(@error.isErrorMsgDisplayed?("Last Seen Within (Months) " + MENTAL_HEALTH + " field is required")).to eq(false)

      end

      it "Logout and Log back in as different user for same location to verify the last saved data is displayed" do
        @common.logoutAndLogbackWithADifferentUser("ACCESS50", "VERIFY50!", "BOSTON HCS VAMC")
        @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)

        Watir::Wait.until {@landing.footerUserInfo == "Logged in as PROVIDER, FIFTY"}
        expect(@landing.footerUserInfo).to eq("Logged in as PROVIDER, FIFTY")

        expect(@landing.primary_header).to eq("Home")
        expect(@landing.secondary_header).to eq("Manage Settings")

        @manage_setting.clickOption('Requests')
        expect(@landing.primary_header).to eq("Requests")

        Watir::Wait.until {@table.tableList_elements.length > 1}

        #Validate the selections
        expect(@request_setting.audiology).to eq("Yes - Based Upon Time Frame")
        expect(@request_setting.audiologyLastSeen).to eq("24 months (730 days)")
        expect(@request_setting.optometry).to eq("Yes - Based Upon Time Frame")
        expect(@request_setting.optometryLastSeen).to eq("12 months (365 days)")
        expect(@request_setting.outpatientMentalHealth).to eq("Yes - Based Upon Time Frame")
        expect(@request_setting.outpatientMentalHealthLastSeen).to eq("24 months (730 days)")

        expect(@request_setting.primaryCareRequestLimit).to eq("4")
        expect(@request_setting.audiologyRequestLimit).to eq("3")
        expect(@request_setting.optometryRequestLimit).to eq("2")
        expect(@request_setting.outpatientMentalHealthRequestLimit).to eq("1")

      end

      context 'AC#VARUT-211|TC#VARUT-212: Utility - Navigate without Save Confirmation Modal Validate' do
        it "Navigate without save and validate changes are not saved" do
          #Select different values for each field other than what is being saved.
          @request_setting.primaryCare = "Yes - Any Veteran"
          @request_setting.audiology = "Yes - Any Veteran"
          @request_setting.optometry = "Yes - Any Veteran"
          @request_setting.outpatientMentalHealth = "Yes - Any Veteran"

          #Click the home icon and validate the confirmation modal

          @base.home_btn

          @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)

          expect(@modal.modalTitle).to eq("Confirmation")
          expect(@modal.content).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
          @modal.return

          Watir::Wait.until {@table.tableList_elements.length > 1}
          @common.waitWhileSpinnerPresent

          #Validate the last selected values
          expect(@request_setting.audiology).to eq("Yes - Any Veteran")
          expect(@request_setting.audiologyLastSeen_element.exists?).to eq(false)
          expect(@request_setting.optometry).to eq("Yes - Any Veteran")
          expect(@request_setting.optometryLastSeen_element.exists?).to eq(false)
          expect(@request_setting.outpatientMentalHealth).to eq("Yes - Any Veteran")
          expect(@request_setting.outpatientMentalHealthLastSeen_element.exists?).to eq(false)

          @request_setting.outpatientMentalHealth = "No"

          #Select Continue in the confirmation modal
          @base.home_btn

          @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)
          expect(@modal.modalTitle).to eq("Confirmation")

          @modal.continue

          @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)

          #Go back to Requests and verify the last saved selections are displayed
          @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
          expect(@landing.primary_header).to eq("Home")
          expect(@landing.secondary_header_element.when_present(TIME_OUT_LIMIT))

          #expect(@manage_setting.manage_settings_options_elements.when_present(TIME_OUT_LIMIT))
          sleep (3)
          @manage_setting.clickOption('Requests')

          Watir::Wait.until {@table.tableList_elements.length > 1}

          expect(@request_setting.audiology).to eq("Yes - Based Upon Time Frame")
          expect(@request_setting.audiologyLastSeen).to eq("24 months (730 days)")
          expect(@request_setting.optometry).to eq("Yes - Based Upon Time Frame")
          expect(@request_setting.optometryLastSeen).to eq("12 months (365 days)")
          expect(@request_setting.outpatientMentalHealth).to eq("Yes - Based Upon Time Frame")
          expect(@request_setting.outpatientMentalHealthLastSeen).to eq("24 months (730 days)")

        end
      end

    end
  end






